/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.templates;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mtj.internal.templates.Messages;
import org.eclipse.mtj.ui.templates.AbstractTemplateWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayTemplateWizardPage
extends AbstractTemplateWizardPage {
    private static final String NEW_TEXT_BOX = "new TextBox(\"Text [Screen {0}]\", \"\", 100, TextField.ANY)";
    private static final String NEW_LIST = "new List(\"List [Screen {0}]\", List.IMPLICIT)";
    private static final String NEW_FORM = "new Form(\"Form [Screen {0}]\")";
    private static final String IMPORT_TEXT = "import javax.microedition.lcdui.TextBox;\n";
    private static final String IMPORT_LIST = "import javax.microedition.lcdui.List;\n";
    private static final String IMPORT_FORM = "import javax.microedition.lcdui.Form;\n";
    private static final String IMPORT_TEXT_FIELD = "import javax.microedition.lcdui.TextField;\n";
    private Button textBtn1;
    private Button listBtn1;
    private Button formBtn1;
    private Button textBtn2;
    private Button listBtn2;
    private Button formBtn2;
    private Button listBtn3;
    private Button formBtn3;
    private Button textBtn3;

    public void createControl(Composite parent) {
        int i = 1;
        while (i <= 3) {
            this.createScreenGroup(i, parent);
            ++i;
        }
    }

    private void createScreenGroup(int num, Composite parent) {
        GridData data = null;
        parent.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(parent, 0);
        group.setText(NLS.bind((String)Messages.DisplayTemplateProvider_0, (Object)num));
        data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Button textBtn = new Button((Composite)group, 16);
        textBtn.setText("javax.microedition.lcdui.TextBox");
        data = new GridData(768);
        textBtn.setLayoutData((Object)data);
        textBtn.setSelection(true);
        Button listBtn = new Button((Composite)group, 16);
        listBtn.setText("javax.microedition.lcdui.List");
        data = new GridData(768);
        listBtn.setLayoutData((Object)data);
        Button formBtn = new Button((Composite)group, 16);
        formBtn.setText("javax.microedition.lcdui.Form");
        data = new GridData(768);
        formBtn.setLayoutData((Object)data);
        switch (num) {
            case 1: {
                this.textBtn1 = textBtn;
                this.listBtn1 = listBtn;
                this.formBtn1 = formBtn;
                break;
            }
            case 2: {
                this.textBtn2 = textBtn;
                this.listBtn2 = listBtn;
                this.formBtn2 = formBtn;
                break;
            }
            case 3: {
                this.textBtn3 = textBtn;
                this.listBtn3 = listBtn;
                this.formBtn3 = formBtn;
            }
        }
    }

    public Map<String, String> getDictionary() {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("$screen1$", this.getScreen1());
        dictionary.put("$screen2$", this.getScreen2());
        dictionary.put("$screen3$", this.getScreen3());
        dictionary.put("$import$", this.getImports());
        return dictionary;
    }

    private String getScreen3() {
        StringBuffer buffer = new StringBuffer();
        if (this.textBtn3.getSelection()) {
            buffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)3));
        } else if (this.listBtn3.getSelection()) {
            buffer.append(NLS.bind((String)NEW_LIST, (Object)3));
        } else if (this.formBtn3.getSelection()) {
            buffer.append(NLS.bind((String)NEW_FORM, (Object)3));
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    private String getScreen2() {
        StringBuffer buffer = new StringBuffer();
        if (this.textBtn2.getSelection()) {
            buffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)2));
        } else if (this.listBtn2.getSelection()) {
            buffer.append(NLS.bind((String)NEW_LIST, (Object)2));
        } else if (this.formBtn2.getSelection()) {
            buffer.append(NLS.bind((String)NEW_FORM, (Object)2));
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    private String getScreen1() {
        StringBuffer buffer = new StringBuffer();
        if (this.textBtn1.getSelection()) {
            buffer.append(NLS.bind((String)NEW_TEXT_BOX, (Object)1));
        } else if (this.listBtn1.getSelection()) {
            buffer.append(NLS.bind((String)NEW_LIST, (Object)1));
        } else if (this.formBtn1.getSelection()) {
            buffer.append(NLS.bind((String)NEW_FORM, (Object)1));
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    private String getImports() {
        StringBuffer buffer = new StringBuffer();
        if (this.formBtn1.getSelection() || this.formBtn2.getSelection() || this.formBtn3.getSelection()) {
            buffer.append(IMPORT_FORM);
        }
        if (this.listBtn1.getSelection() || this.listBtn2.getSelection() || this.listBtn3.getSelection()) {
            buffer.append(IMPORT_LIST);
        }
        if (this.textBtn1.getSelection() || this.textBtn2.getSelection() || this.textBtn3.getSelection()) {
            buffer.append(IMPORT_TEXT);
            buffer.append(IMPORT_TEXT_FIELD);
        }
        return buffer.toString();
    }

    public boolean isPageComplete() {
        return true;
    }
}

