/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.microemu;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.microemu.Activator;
import org.eclipse.mtj.internal.toolkit.microemu.Messages;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDevice;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDeviceSkin;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuLaunchTemplateProperties;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroEmuDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final MicroEmuDeviceSkin[] EMULATOR_DEVICE_SKINS = new MicroEmuDeviceSkin[]{new MicroEmuDeviceSkin("microemulator.jar", "org/microemu/device/default/device.xml", "Default device"), new MicroEmuDeviceSkin("devices/microemu-device-large.jar", "org/microemu/device/large/device.xml", "Large Device"), new MicroEmuDeviceSkin("devices/microemu-device-minimum.jar", "org/microemu/device/minimum/device.xml", "Minimum device")};
    private static final String EMULATOR_JAR_NAME = "microemulator.jar";
    private static final String MAIN_CLASS_NAME = "org.microemu.app.Main";
    private static final String PROPS_FILE = "microemu.properties";

    public List<IDevice> importDevices(File directory, IProgressMonitor monitor) {
        ArrayList<IMIDPDevice> deviceList = null;
        try {
            File jarFile = new File(directory, EMULATOR_JAR_NAME);
            if (jarFile.exists() && this.hasMainClassAttribute(jarFile, MAIN_CLASS_NAME)) {
                deviceList = new ArrayList<IMIDPDevice>();
                MicroEmuDeviceSkin[] microEmuDeviceSkinArray = EMULATOR_DEVICE_SKINS;
                int n = EMULATOR_DEVICE_SKINS.length;
                int n2 = 0;
                while (n2 < n) {
                    MicroEmuDeviceSkin element = microEmuDeviceSkinArray[n2];
                    IMIDPDevice singleDevice = this.createDevice(jarFile, element);
                    deviceList.add(singleDevice);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            MTJLogger.log((int)2, (String)Messages.MicroEmuDeviceImporter_import_error, (Throwable)e);
        }
        return deviceList;
    }

    private void addDeviceLibraries(File jarFile, IDeviceClasspath deviceClasspath, ILibraryImporter libraryImporter) {
        String[] entries;
        String classpathString = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> replaceableParameters = new HashMap<String, String>();
        replaceableParameters.put(MicroEmuLaunchTemplateProperties.TOOLKITROOT.toString(), jarFile.getParent());
        classpathString = ReplaceableParametersProcessor.processReplaceableValues((String)classpathString, replaceableParameters);
        String[] stringArray = entries = classpathString.split(";");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entrie = stringArray[n2];
            IMIDPLibrary library = (IMIDPLibrary)libraryImporter.createLibraryFor(new File(entrie));
            IMIDPAPI api = library.getAPI(MIDPAPIType.UNKNOWN);
            if (api != null) {
                if (api.getIdentifier().equalsIgnoreCase("cldcapi11.jar")) {
                    api.setIdentifier("CLDC");
                    api.setType(MIDPAPIType.CONFIGURATION);
                    api.setName("Connected Limited Device Configuration");
                    api.setVersion(new Version("1.1"));
                } else if (api.getIdentifier().equalsIgnoreCase("midpapi20.jar")) {
                    api.setIdentifier("MIDP");
                    api.setType(MIDPAPIType.PROFILE);
                    api.setName("Mobile Information Device Profile");
                    api.setVersion(new Version("2.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-jsr-75.jar")) {
                    api.setIdentifier("JSR75");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("PDA Optional Packages for the J2ME Platform");
                    api.setVersion(new Version("1.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-jsr-82.jar")) {
                    api.setIdentifier("JSR82");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Java APIs for Bluetooth");
                    api.setVersion(new Version("1.1"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-jsr-120.jar")) {
                    api.setIdentifier("JSR120");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Wireless Messaging API");
                    api.setVersion(new Version("1.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-jsr-135.jar")) {
                    api.setIdentifier("JSR135");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Mobile Media API");
                    api.setVersion(new Version("1.0"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-nokiaui.jar")) {
                    api.setIdentifier("Nokia UI");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Nokia UI API");
                    api.setVersion(new Version("1.1"));
                } else if (api.getIdentifier().equalsIgnoreCase("microemu-siemensapi.jar")) {
                    api.setIdentifier("Siemens API");
                    api.setType(MIDPAPIType.OPTIONAL);
                    api.setName("Siemens API");
                    api.setVersion(new Version("1.0"));
                }
                deviceClasspath.addEntry((ILibrary)library);
            }
            ++n2;
        }
    }

    private IMIDPDevice createDevice(File jarFile, MicroEmuDeviceSkin skin) {
        MicroEmuDevice device = new MicroEmuDevice();
        device.setBundle(Activator.getDefault().getBundle().getSymbolicName());
        device.setClasspath(this.getDeviceClasspath(jarFile));
        device.setDebugServer(this.isDebugServer());
        device.setDescription("Microemulator Device");
        device.setDeviceProperties(new Properties());
        device.setGroupName("Microemulator");
        device.setName(skin.getName());
        device.setPreverifier(this.getPreverifier(jarFile));
        device.setProtectionDomains(new String[0]);
        device.setLaunchCommandTemplate(this.getLaunchCommand());
        device.setRoot(jarFile.getParentFile());
        device.setSkin(skin);
        ISymbolSet dss = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)device);
        dss.setName(device.getName());
        device.setSymbolSet(dss);
        Version v = new Version(1, 0, 0);
        ISDK sdk = BasicSDK.getSDK((String)"Microemulator", (Version)v);
        device.setSDK(sdk);
        ((BasicSDK)sdk).addDevice((IDevice)device);
        return device;
    }

    private IDeviceClasspath getDeviceClasspath(File jarFile) {
        IDeviceClasspath deviceClasspath = MTJCore.createNewDeviceClasspath();
        this.addDeviceLibraries(jarFile, deviceClasspath, MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei"));
        return deviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return Activator.getDefault().getBundle().getEntry(PROPS_FILE);
    }
}

