/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.eclipse.mtj.internal.toolkit.uei.Messages;
import org.eclipse.mtj.internal.toolkit.uei.UeiPlugin;
import org.eclipse.mtj.internal.toolkit.uei.properties.UEIDeviceDefinition;

public class DeviceDefinitionManager {
    public static final String PROPS_FILE = "uei_device.properties";
    private static final String DEVICES = "devices";
    private static DeviceDefinitionManager instance;
    private List<UEIDeviceDefinition> deviceDefinitions = null;

    public static synchronized DeviceDefinitionManager getInstance() {
        if (instance == null) {
            instance = new DeviceDefinitionManager();
        }
        return instance;
    }

    private DeviceDefinitionManager() {
        if (this.deviceDefinitions == null) {
            this.initializeDeviceDefinitions();
        }
    }

    public UEIDeviceDefinition getDeviceDefinition(String device) {
        UEIDeviceDefinition deviceDef = null;
        Iterator<UEIDeviceDefinition> iterator = this.deviceDefinitions.iterator();
        while (iterator.hasNext() && deviceDef == null) {
            UEIDeviceDefinition defElement = iterator.next();
            Matcher matcher = defElement.getMatchPattern().matcher(device);
            if (!matcher.find()) continue;
            deviceDef = defElement;
        }
        return deviceDef;
    }

    private InputStream getUEIDevicesPropertiesStream() {
        InputStream stream = null;
        try {
            URL propsFileURL = UeiPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
            if (propsFileURL != null) {
                stream = propsFileURL.openStream();
            } else {
                UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_file_not_found);
            }
        }
        catch (IllegalStateException e) {
            UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_IllegalState, e);
        }
        catch (IOException ioe) {
            UeiPlugin.debugLog(Messages.UEIDeviceImporter_getUEIDevicesPropertiesStream_IOError, ioe);
        }
        return stream;
    }

    private void initializeDeviceDefinitions() {
        this.deviceDefinitions = new ArrayList<UEIDeviceDefinition>();
        Properties defProps = new Properties();
        InputStream is = this.getUEIDevicesPropertiesStream();
        if (is != null) {
            block21: {
                try {
                    defProps.load(is);
                }
                catch (IOException ioe) {
                    UeiPlugin.debugLog(Messages.DeviceDefinitionManager_failed_reading_file, ioe);
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                    }
                    break block21;
                }
                catch (IllegalArgumentException iae) {
                    try {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_malformed_unicode_esc_seq, iae);
                    }
                    catch (Throwable throwable) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                    }
                    break block21;
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_closeStream_fail);
                }
            }
            String devCatList = defProps.getProperty(DEVICES, "");
            if (!devCatList.equals("")) {
                String[] deviceCategories;
                String[] stringArray = deviceCategories = devCatList.split(",");
                int n = deviceCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    try {
                        this.deviceDefinitions.add(new UEIDeviceDefinition(element, defProps));
                    }
                    catch (IllegalArgumentException iae) {
                        UeiPlugin.debugLog(iae.getMessage(), iae);
                    }
                    catch (NullPointerException npe) {
                        UeiPlugin.debugLog(npe.getMessage(), npe);
                    }
                    ++n2;
                }
            } else {
                UeiPlugin.debugLog(Messages.DeviceDefinitionManager_readDeviceDefinitions_invalid_file);
            }
        }
    }
}

