/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigurationErrorDialog
extends IconAndMessageDialog {
    private String preferenceNodeId;
    private String title;
    private String buttonText;

    public ConfigurationErrorDialog(Shell parentShell, String preferenceNodeId, String title, String message, String buttonText) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.preferenceNodeId = preferenceNodeId;
        this.buttonText = buttonText;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createMessageArea(composite);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        Button configureProguardButton = new Button(composite, 8);
        configureProguardButton.setText(this.buttonText);
        configureProguardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.widget.getDisplay().getActiveShell();
                PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
                PreferenceDialog dialog = new PreferenceDialog(shell, manager);
                dialog.setSelectedNode(ConfigurationErrorDialog.this.preferenceNodeId);
                dialog.open();
            }
        });
        return composite;
    }

    protected Image getImage() {
        return this.getErrorImage();
    }
}

