/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.configurations;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.project.runtime.event.AddMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeChangeListener;
import org.eclipse.mtj.core.project.runtime.event.IMTJRuntimeListChangeListener;
import org.eclipse.mtj.core.project.runtime.event.RemoveMTJRuntimeEvent;
import org.eclipse.mtj.core.project.runtime.event.SwitchActiveMTJRuntimeEvent;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.configurations.ConfigAddAndEditWizard;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ConfigManageComponent
implements IMTJRuntimeListChangeListener {
    private static final String CONFIG_MANAGE_SETTINGS = "ConfigManageComponentSettings";
    private CheckboxTableViewer configViewer;
    private MTJRuntimeList configurations;
    private IMidletSuiteProject midletSuiteProject;
    private boolean includeGroup = true;
    private boolean configsChanged;
    private ICheckStateListener checkStateListener;
    private IMTJRuntimeListChangeListener configurationsChangeListener;
    private IMTJRuntimeChangeListener configurationChangeListener;
    private String description;
    private Button editButton;
    private Button removeButton;

    public ConfigManageComponent() {
        this(null);
    }

    public ConfigManageComponent(IMidletSuiteProject midletSuiteProject) {
        this.midletSuiteProject = midletSuiteProject;
        this.configurations = midletSuiteProject != null ? midletSuiteProject.getRuntimeList() : MTJRuntimeListUtils.createMTJRuntimeList();
        this.configurations.addMTJRuntimeListChangeListener((IMTJRuntimeListChangeListener)this);
    }

    public void activeMTJRuntimeSwitched(SwitchActiveMTJRuntimeEvent event) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.setAllChecked(false);
        this.configViewer.setChecked((Object)this.configurations.getActiveMTJRuntime(), true);
        this.configViewer.refresh();
    }

    private void addConfiguration(SelectionEvent event) {
        this.addConfigurationsChangeListener();
        ConfigAddAndEditWizard wizard = new ConfigAddAndEditWizard(this.configurations, null);
        Shell shell = event.widget.getDisplay().getActiveShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            this.configViewer.refresh();
            this.changeActiveConfigIfNecessary();
            this.configsChanged = true;
        }
        this.removeConfigurationsChangeListener();
    }

    private void addConfigurationChangeListener(MTJRuntime configuration) {
        if (this.configurationChangeListener != null && configuration != null) {
            configuration.addMTJRuntimeChangeListener(this.configurationChangeListener);
        }
    }

    private void addConfigurationsChangeListener() {
        if (this.configurationsChangeListener != null) {
            this.configurations.addMTJRuntimeListChangeListener(this.configurationsChangeListener);
        }
    }

    private boolean canPerformRemoveConfigs(TableItem[] selected, SelectionEvent event) {
        if (this.midletSuiteProject != null && selected.length >= this.configurations.size()) {
            Shell shell = event.widget.getDisplay().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)MTJUIMessages.Configuration_ErrorMessage_Title, (String)MTJUIMessages.Configuration_ErrorMessage_MustHaveAtLeastOneConfig);
            return false;
        }
        return true;
    }

    private void changeActiveConfigIfNecessary() {
        if (!this.configurations.isEmpty() && this.configurations.getActiveMTJRuntime() == null) {
            MTJRuntime activeConfig = (MTJRuntime)this.configurations.get(0);
            this.configurations.switchActiveMTJRuntime(activeConfig);
            this.configViewer.setChecked((Object)activeConfig, true);
            this.fireCheckStateChanged();
        }
    }

    public void mtjRuntimeAdded(AddMTJRuntimeEvent event) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.refresh();
    }

    public void mtjRuntimeRemoved(RemoveMTJRuntimeEvent event) {
        if (this.configViewer.getControl().isDisposed()) {
            return;
        }
        this.configViewer.refresh();
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(composite, 8);
        addButton.setText(MTJUIMessages.Configuration_Add);
        GridData gd = new GridData(768);
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigManageComponent.this.addConfiguration(e);
            }
        });
        this.editButton = new Button(composite, 8);
        this.editButton.setText(MTJUIMessages.Configuration_Edit);
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigManageComponent.this.editConfiguration();
            }
        });
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(MTJUIMessages.Configuration_Remove);
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigManageComponent.this.removeConfiguration(e);
            }
        });
    }

    private void createConfigTableViewer(Composite composite) {
        GridData gd = new GridData();
        int styles = 68130;
        Table table = new Table(composite, styles);
        gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 300;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.configViewer = new CheckboxTableViewer(table);
        this.configViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.configViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.configViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConfigManageComponent.this.handleCheckStateChange(event);
                if (ConfigManageComponent.this.checkStateListener != null) {
                    ConfigManageComponent.this.checkStateListener.checkStateChanged(event);
                }
            }
        });
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigManageComponent.this.validateControls();
            }
        });
        this.configViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigManageComponent.this.editConfiguration();
            }
        });
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings(CONFIG_MANAGE_SETTINGS);
        TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.Configuration_Active, 20.0f, null), new TableColumnInfo(MTJUIMessages.Configuration_Configuration, 80.0f, null)};
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 300, COLUMN_INFO, 1);
        viewerConfiguration.configure((TableViewer)this.configViewer);
        this.configViewer.setInput((Object)this.configurations);
        if (this.configurations != null && this.configurations.size() > 0) {
            this.configViewer.setChecked((Object)this.configurations.getActiveMTJRuntime(), true);
        }
    }

    public void createContents(Composite parent) {
        Composite composite;
        if (this.includeGroup) {
            Group group = new Group(parent, 0);
            group.setText(MTJUIMessages.Configuration_Configurations);
            composite = group;
        } else {
            composite = new Composite(parent, 0);
        }
        this.setCompositeLayout(parent, composite);
        this.createDescription(composite);
        this.createConfigTableViewer(composite);
        this.createButtons(composite);
        this.validateControls();
    }

    private void createDescription(Composite parent) {
        if (this.description == null || this.description.trim().length() == 0) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(this.description);
    }

    public void dispose() {
        this.configurations.removeMTJRuntimeListChangeListener((IMTJRuntimeListChangeListener)this);
    }

    private void editConfiguration() {
        TableItem[] selected = this.configViewer.getTable().getSelection();
        if (selected.length < 1) {
            return;
        }
        MTJRuntime currentConfig = (MTJRuntime)selected[0].getData();
        this.addConfigurationChangeListener(currentConfig);
        ConfigAddAndEditWizard wizard = new ConfigAddAndEditWizard(this.configurations, currentConfig);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        wizard.setMidletSuiteProject((IMTJProject)this.midletSuiteProject);
        if (dialog.open() == 0) {
            this.configViewer.refresh();
            this.configsChanged = true;
        }
        this.removeConfigurationChangeListener(currentConfig);
    }

    private void fireCheckStateChanged() {
        if (this.checkStateListener == null) {
            return;
        }
        Object[] configs = this.configViewer.getCheckedElements();
        if (configs.length <= 0) {
            return;
        }
        final MTJRuntime config = (MTJRuntime)configs[0];
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ConfigManageComponent.this.checkStateListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)ConfigManageComponent.this.configViewer, (Object)config, true));
            }
        });
    }

    public MTJRuntime getActiveConfiguration() {
        if (this.configurations == null) {
            return null;
        }
        return this.configurations.getActiveMTJRuntime();
    }

    public MTJRuntimeList getConfigurations() {
        return this.configurations;
    }

    private void handleCheckStateChange(CheckStateChangedEvent event) {
        this.addConfigurationsChangeListener();
        MTJRuntime config = (MTJRuntime)event.getElement();
        if (!event.getChecked()) {
            this.configViewer.setChecked((Object)config, true);
            return;
        }
        this.configurations.switchActiveMTJRuntime(config);
        this.configViewer.setAllChecked(false);
        this.configViewer.setChecked((Object)config, true);
        this.configsChanged = true;
        this.removeConfigurationsChangeListener();
    }

    public void performCancel() {
        this.restoreConfigurations();
    }

    public void performFinish() {
    }

    private void removeConfiguration(SelectionEvent event) {
        this.addConfigurationsChangeListener();
        Table table = this.configViewer.getTable();
        TableItem[] selected = table.getSelection();
        if (!this.canPerformRemoveConfigs(selected, event)) {
            return;
        }
        ArrayList<MTJRuntime> toRemoves = new ArrayList<MTJRuntime>();
        TableItem[] tableItemArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            MTJRuntime config = (MTJRuntime)tableItem.getData();
            toRemoves.add(config);
            ++n2;
        }
        this.configurations.removeAll(toRemoves);
        this.changeActiveConfigIfNecessary();
        this.configViewer.refresh();
        this.configsChanged = true;
        this.removeConfigurationsChangeListener();
    }

    private void removeConfigurationChangeListener(MTJRuntime configuration) {
        if (configuration != null) {
            configuration.removeMTJRuntimeChangeListener(this.configurationChangeListener);
        }
    }

    private void removeConfigurationsChangeListener() {
        this.configurations.removeMTJRuntimeListChangeListener(this.configurationsChangeListener);
    }

    private void restoreConfigurations() {
        if (this.midletSuiteProject == null) {
            return;
        }
        if (!this.configsChanged) {
            return;
        }
        MTJRuntimeList configsInMetadataFile = MTJCore.createMetaData((IProject)this.midletSuiteProject.getProject(), (ProjectType)ProjectType.MIDLET_SUITE).getRuntimeList();
        this.configurations.clear();
        this.configurations.addAll((Collection)configsInMetadataFile);
        this.configurations.switchActiveMTJRuntime(configsInMetadataFile.getActiveMTJRuntime());
    }

    public void setCheckStateListener(ICheckStateListener checkStateListener) {
        this.checkStateListener = checkStateListener;
    }

    private void setCompositeLayout(Composite parent, Composite child) {
        int columns = 1;
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            columns = ((GridLayout)layout).numColumns;
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = columns;
        child.setLayoutData((Object)gd);
        child.setLayout((Layout)new GridLayout(2, false));
    }

    public void setConfigurationChangeListener(IMTJRuntimeChangeListener listener) {
        this.configurationChangeListener = listener;
    }

    public void setConfigurationsChangeListener(IMTJRuntimeListChangeListener listener) {
        this.configurationsChangeListener = listener;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIncludeGroup(boolean includeGroup) {
        this.includeGroup = includeGroup;
    }

    private void validateControls() {
        boolean isEditButtonEnable = this.configViewer.getTable().getSelection().length == 1;
        this.editButton.setEnabled(isEditButtonEnable);
        boolean isRemoveButtonEnable = this.configViewer.getTable().getSelection().length > 0;
        this.removeButton.setEnabled(isRemoveButtonEnable);
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Collection configurations = (Collection)inputElement;
            return configurations.toArray(new MTJRuntime[configurations.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COL_CHECKBOX = 0;
        private static final int COL_CONFIG_NAME = 1;

        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MTJRuntime config = (MTJRuntime)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return config.getName();
                }
            }
            return "";
        }
    }
}

