/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.devices.DeviceEditorConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceEditorRegistry
implements IRegistryChangeListener {
    public static final String ID_EXTENSION = "deviceeditor";
    private static DeviceEditorConfigElement[] editors;
    private static DeviceEditorRegistry registryChangeListener;

    public static DeviceEditorConfigElement findEditorElement(IDevice device) {
        DeviceEditorConfigElement element = null;
        DeviceEditorConfigElement[] elements = DeviceEditorRegistry.getEditors();
        Class<?> deviceClass = device.getClass();
        DeviceEditorConfigElement[] deviceEditorConfigElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceEditorConfigElement element2 = deviceEditorConfigElementArray[n2];
            String matchClassName = element2.getDeviceClass();
            if (DeviceEditorRegistry.isMatchingType(deviceClass, matchClassName)) {
                element = element2;
                break;
            }
            ++n2;
        }
        return element;
    }

    private static DeviceEditorConfigElement[] getEditors() {
        if (editors == null) {
            editors = DeviceEditorRegistry.readEditors();
            registryChangeListener = new DeviceEditorRegistry();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)registryChangeListener);
        }
        return editors;
    }

    private static boolean isMatchingType(Class<?> type, String matchClassName) {
        boolean matches = false;
        if (type != null) {
            matches = type.getName().equals(matchClassName);
            if (!matches) {
                matches = DeviceEditorRegistry.isMatchingType(type.getSuperclass(), matchClassName);
            }
            if (!matches) {
                Class<?>[] interfaces = type.getInterfaces();
                int i = 0;
                while (!matches && i < interfaces.length) {
                    matches = DeviceEditorRegistry.isMatchingType(interfaces[i], matchClassName);
                    ++i;
                }
            }
        }
        return matches;
    }

    private static DeviceEditorConfigElement[] readEditors() {
        String plugin = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(plugin, ID_EXTENSION);
        DeviceEditorConfigElement[] elements = new DeviceEditorConfigElement[configElements.length];
        int i = 0;
        while (i < configElements.length) {
            elements[i] = new DeviceEditorConfigElement(configElements[i]);
            ++i;
        }
        return elements;
    }

    private DeviceEditorRegistry() {
    }

    public void registryChanged(IRegistryChangeEvent event) {
        String plugin = MTJUIPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionDelta[] deltas = event.getExtensionDeltas(plugin, ID_EXTENSION);
        if (deltas.length > 0) {
            editors = DeviceEditorRegistry.readEditors();
        }
    }
}

