/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.devices;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.swt.graphics.Image;

public class DeviceTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String TEXT_UNKNOWN = "";
    private static final int COL_CHECKBOX = 0;
    private static final int COL_GROUP_NAME = 1;
    private static final int COL_NAME = 2;
    private static final int COL_CONFIGURATION = 3;
    private static final int COL_PROFILE = 4;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = TEXT_UNKNOWN;
        IDevice device = (IDevice)element;
        switch (columnIndex) {
            case 0: {
                text = TEXT_UNKNOWN;
                break;
            }
            case 2: {
                text = device.getName();
                break;
            }
            case 1: {
                text = device.getSDKName();
                break;
            }
            case 3: {
                text = this.getConfigurationText((IMIDPDevice)device);
                break;
            }
            case 4: {
                text = this.getProfileText((IMIDPDevice)device);
            }
        }
        return text;
    }

    private String getConfigurationText(IMIDPDevice device) {
        String text = TEXT_UNKNOWN;
        IMIDPAPI api = device.getCLDCAPI();
        if (api != null) {
            text = api.toString();
        }
        return text;
    }

    private String getProfileText(IMIDPDevice device) {
        String text = TEXT_UNKNOWN;
        IMIDPAPI api = device.getMIDPAPI();
        if (api != null) {
            text = api.toString();
        }
        return text;
    }
}

