/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;
import org.eclipse.mtj.internal.core.sign.PermissionsGroupsRegistry;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class SecurityPermissionsDialog {
    public static CheckedTreeSelectionDialog createDialog(Shell _shell) {
        SecurityPermissionsDialog instance;
        SecurityPermissionsDialog securityPermissionsDialog = instance = new SecurityPermissionsDialog();
        securityPermissionsDialog.getClass();
        SecurityPermissionsDialogLabelProvider securityPermissionsDialogLabelProvider = securityPermissionsDialog.new SecurityPermissionsDialogLabelProvider();
        SecurityPermissionsDialog securityPermissionsDialog2 = instance;
        securityPermissionsDialog2.getClass();
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(_shell, (ILabelProvider)securityPermissionsDialogLabelProvider, (ITreeContentProvider)securityPermissionsDialog2.new SecurityPermissionsDialogContentProvider());
        dialog.setTitle(MTJUIMessages.SecurityPermissionsDialog_title);
        dialog.setMessage(MTJUIMessages.SecurityPermissionsDialog_message);
        dialog.setContainerMode(true);
        dialog.setInput((Object)PermissionsGroupsRegistry.getInstance());
        return dialog;
    }

    private SecurityPermissionsDialog() {
    }

    public class PermissionNode {
        private PermissionsGroup parent;
        private String permission;

        public PermissionNode(String _permission, PermissionsGroup _parent) {
            this.permission = _permission;
            this.parent = _parent;
        }

        public PermissionsGroup getParent() {
            return this.parent;
        }

        public String getPermission() {
            return this.permission;
        }
    }

    private class SecurityPermissionsDialogContentProvider
    implements ITreeContentProvider {
        private SecurityPermissionsDialogContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PermissionsGroup) {
                PermissionsGroup permissionsGroup = (PermissionsGroup)parentElement;
                ArrayList<PermissionNode> children = new ArrayList<PermissionNode>();
                for (String permission : permissionsGroup.getPermissions()) {
                    children.add(new PermissionNode(permission, permissionsGroup));
                }
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof PermissionNode) {
                return ((PermissionNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof PermissionsGroup;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PermissionsGroupsRegistry) {
                PermissionsGroupsRegistry registry = (PermissionsGroupsRegistry)inputElement;
                return registry.getPermissions().toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class SecurityPermissionsDialogLabelProvider
    extends LabelProvider {
        private SecurityPermissionsDialogLabelProvider() {
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof PermissionsGroup) {
                text = ((PermissionsGroup)element).getClassName();
            } else if (element instanceof PermissionNode) {
                text = ((PermissionNode)element).getPermission();
            }
            return text;
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof PermissionsGroup) {
                image = MTJUIPluginImages.DESC_CLASS_OBJ.createImage();
            } else if (element instanceof PermissionNode) {
                image = MTJUIPluginImages.DESC_PERMISSION_OBJ.createImage();
            }
            return image;
        }
    }
}

