/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.l10n.RegExpStringExternalizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StringLocalizationCandidatesDialog
extends Dialog {
    private ICompilationUnit[] cus;
    private ICompilationUnit cu;
    private ListViewer viewer;

    public StringLocalizationCandidatesDialog(Shell _parentShell, ICompilationUnit[] _cus) {
        super(_parentShell);
        this.cus = _cus;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Localize Strings");
    }

    protected Control createDialogArea(Composite _parent) {
        _parent.setLayout((Layout)new GridLayout(1, false));
        Composite parent = new Composite(_parent, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new ListViewer(parent, 2820);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<StringOccurences> result = new ArrayList<StringOccurences>();
                if (inputElement instanceof ICompilationUnit[]) {
                    ICompilationUnit[] iCompilationUnitArray = (ICompilationUnit[])inputElement;
                    int n = iCompilationUnitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit cu = iCompilationUnitArray[n2];
                        RegExpStringExternalizer externalizer = new RegExpStringExternalizer();
                        try {
                            IRegion[] regions = externalizer.externalize(cu.getBuffer(), true);
                            if (regions.length > 0) {
                                StringOccurences occurences = new StringOccurences();
                                occurences.occurrences = regions.length;
                                occurences.className = cu.getResource().getFullPath().toString();
                                occurences.cu = cu;
                                result.add(occurences);
                            }
                        }
                        catch (JavaModelException e) {
                            MTJLogger.log((int)4, (Throwable)e);
                        }
                        ++n2;
                    }
                }
                return result.toArray(new StringOccurences[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof StringOccurences) {
                    StringOccurences data = (StringOccurences)element;
                    result = NLS.bind((String)"{0} in {1}", (Object[])new String[]{String.valueOf(data.occurrences), data.className});
                }
                return result;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = StringLocalizationCandidatesDialog.this.viewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    StringOccurences occurences = (StringOccurences)((IStructuredSelection)selection).getFirstElement();
                    StringLocalizationCandidatesDialog.this.cu = occurences.cu;
                }
            }
        });
        this.viewer.setInput((Object)this.cus);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 200;
        this.viewer.getList().setLayoutData((Object)gridData);
        return parent;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (button != null && id == 0) {
            button.setText("Localize...");
        }
        return button;
    }

    public ICompilationUnit getSelectedClass() {
        return this.cu;
    }

    private class StringOccurences {
        public ICompilationUnit cu;
        public String className;
        public int occurrences;

        private StringOccurences() {
        }
    }
}

