/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.editor.IFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFoldingStructureProvider
implements IFoldingStructureProvider,
IModelChangedListener {
    private MTJSourcePage fEditor;
    private IEditingModel fModel;

    public AbstractFoldingStructureProvider(MTJSourcePage editor, IEditingModel model) {
        this.fEditor = editor;
        this.fModel = model;
    }

    @Override
    public void initialize() {
        this.update();
    }

    public void modelChanged(IModelChangedEvent event) {
        this.update();
    }

    public void reconciled(IDocument document) {
        this.update();
    }

    public void update() {
        ProjectionAnnotationModel annotationModel = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (annotationModel == null) {
            return;
        }
        HashSet<Position> currentRegions = new HashSet<Position>();
        try {
            this.addFoldingRegions(currentRegions, this.fModel);
            this.updateFoldingRegions(annotationModel, currentRegions);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void updateFoldingRegions(ProjectionAnnotationModel model, Set<Position> currentRegions) {
        Annotation[] deletions = this.computeDifferences(model, currentRegions);
        HashMap<ProjectionAnnotation, Position> additionsMap = new HashMap<ProjectionAnnotation, Position>();
        for (Position position : currentRegions) {
            additionsMap.put(new ProjectionAnnotation(false), position);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Set<Position> additions) {
        ArrayList deletions = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition((Annotation)annotation);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }
}

