/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.IModelChangeProvider;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJOutlinePage;
import org.eclipse.mtj.internal.ui.editor.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.editor.IFormPage;

public class FormOutlinePage
extends MTJOutlinePage
implements IModelChangedListener,
ISortableContentOutlinePage {
    private boolean sorted;
    private boolean stale;
    private ViewerComparator viewerComparator;
    protected boolean editorSelection = false;
    protected boolean outlineSelection = false;
    protected TreeViewer treeViewer;

    public FormOutlinePage(MTJFormEditor editor) {
        super(editor);
    }

    public ITreeContentProvider createContentProvider() {
        return new BasicContentProvider();
    }

    public void createControl(Composite parent) {
        Tree widget = new Tree(parent, 770);
        this.treeViewer = new TreeViewer(widget);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewerComparator = this.createOutlineSorter();
        if (this.sorted) {
            this.treeViewer.setComparator(this.viewerComparator);
        } else {
            this.treeViewer.setComparator(null);
        }
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.fEditor);
        IBaseModel model = this.fEditor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    public ILabelProvider createLabelProvider() {
        return new BasicLabelProvider();
    }

    public ViewerComparator createOutlineSorter() {
        return new BasicComparator();
    }

    public void dispose() {
        IBaseModel model = this.fEditor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public Control getControl() {
        return this.treeViewer != null ? this.treeViewer.getControl() : null;
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void modelChanged(IModelChangedEvent event) {
        IFormPage page = this.fEditor.getActivePageInstance();
        this.stale = true;
        if (!page.isEditor()) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.stale) {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!FormOutlinePage.this.treeViewer.getControl().isDisposed()) {
                        FormOutlinePage.this.treeViewer.refresh();
                        FormOutlinePage.this.treeViewer.expandAll();
                        FormOutlinePage.this.stale = false;
                    }
                }
            });
        }
    }

    public void selectionChanged(Object item) {
        IFormPage revealPage;
        IFormPage page = this.fEditor.getActivePageInstance();
        String id = this.getParentPageId(item);
        IFormPage newPage = null;
        if (!(id == null || page != null && page.getId().equals(id))) {
            newPage = this.fEditor.setActivePage(id);
        }
        IFormPage iFormPage = revealPage = newPage != null ? newPage : page;
        if (revealPage != null && !(item instanceof IFormPage)) {
            revealPage.selectReveal(item);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.editorSelection) {
            return;
        }
        this.outlineSelection = true;
        try {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                Object item = ssel.getFirstElement();
                this.selectionChanged(item);
            }
            this.fireSelectionChanged(selection);
        }
        finally {
            this.outlineSelection = false;
        }
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelection(ISelection selection) {
        if (this.outlineSelection) {
            return;
        }
        this.editorSelection = true;
        try {
            Object item;
            if (this.treeViewer == null) {
                return;
            }
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (item = ((IStructuredSelection)selection).getFirstElement()) instanceof IDocumentElementNode) {
                while (this.treeViewer.testFindItem(item) == null) {
                    if ((item = ((IDocumentElementNode)item).getParentNode()) == null) break;
                    selection = new StructuredSelection(item);
                }
            }
            this.treeViewer.setSelection(selection);
        }
        finally {
            this.editorSelection = false;
        }
    }

    public void sort(boolean sorting) {
        this.sorted = sorting;
        if (this.treeViewer != null) {
            if (sorting) {
                this.treeViewer.setComparator(this.viewerComparator);
            } else {
                this.treeViewer.setComparator(null);
            }
        }
    }

    private Object[] getPages() {
        IFormPage[] pages;
        ArrayList<IFormPage> formPages = new ArrayList<IFormPage>();
        IFormPage[] iFormPageArray = pages = this.fEditor.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (!page.isEditor()) {
                formPages.add(page);
            }
            ++n2;
        }
        return formPages.toArray();
    }

    protected Object[] getChildren(Object parent) {
        return new Object[0];
    }

    protected String getParentPageId(Object item) {
        if (item instanceof IFormPage) {
            return ((IFormPage)item).getId();
        }
        return null;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public class BasicComparator
    extends ViewerComparator {
        public int category(Object element) {
            Object[] pages = FormOutlinePage.this.getPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i] == element) {
                    return i;
                }
                ++i;
            }
            return Integer.MAX_VALUE;
        }
    }

    public class BasicContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object obj) {
            return FormOutlinePage.this.getChildren(obj);
        }

        public Object[] getElements(Object obj) {
            return FormOutlinePage.this.getPages();
        }

        public Object getParent(Object obj) {
            return null;
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length > 0;
        }
    }

    public class BasicLabelProvider
    extends LabelProvider {
        public Image getImage(Object obj) {
            if (obj instanceof IFormPage) {
                return MTJUIPlugin.getDefault().getLabelProvider().get(MTJUIPluginImages.DESC_PAGE_OBJ);
            }
            return MTJUIPlugin.getDefault().getLabelProvider().getImage(obj);
        }

        public String getText(Object obj) {
            if (obj instanceof IFormPage) {
                return ((IFormPage)obj).getTitle();
            }
            return MTJUIPlugin.getDefault().getLabelProvider().getText(obj);
        }
    }
}

