/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.IEditable;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.IUpdate;

public class MTJFormEditorContributor
extends MultiPageEditorActionBarContributor {
    private ClipboardAction copyAction;
    private ClipboardAction cutAction;
    private Hashtable<String, Action> globalActions = new Hashtable();
    private ClipboardAction pasteAction;
    private SaveAction saveAction;
    private ISharedImages sharedImages;
    protected IFormPage formPage;
    protected MTJFormEditor mtjFormEditor;
    protected RevertAction revertAction;

    public MTJFormEditorContributor(String menuName) {
    }

    public void addClipboardActions(IMenuManager mng) {
        mng.add((IAction)this.cutAction);
        mng.add((IAction)this.copyAction);
        mng.add((IAction)this.pasteAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.revertAction);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        this.contextMenuAboutToShow(mng, true);
    }

    public void contextMenuAboutToShow(IMenuManager mng, boolean addClipboard) {
        if (this.mtjFormEditor != null) {
            this.updateSelectableActions(this.mtjFormEditor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(mng);
        }
        mng.add((IAction)this.saveAction);
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public MTJFormEditor getEditor() {
        return this.mtjFormEditor;
    }

    public IAction getGlobalAction(String id) {
        return (IAction)this.globalActions.get(id);
    }

    public IAction getRevertAction() {
        return this.revertAction;
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public IEditorActionBarContributor getSourceContributor() {
        return null;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.makeActions();
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof MTJSourcePage) {
            MTJSourcePage page = (MTJSourcePage)targetEditor;
            MTJUIPlugin.getActivePage().activate((IWorkbenchPart)page.getEditor());
            return;
        }
        if (!(targetEditor instanceof MTJFormEditor)) {
            return;
        }
        this.mtjFormEditor = (MTJFormEditor)targetEditor;
        this.mtjFormEditor.updateUndo(this.getGlobalAction(ActionFactory.UNDO.getId()), this.getGlobalAction(ActionFactory.REDO.getId()));
        this.setActivePage(this.mtjFormEditor.getActiveEditor());
        this.updateSelectableActions(this.mtjFormEditor.getSelection());
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.mtjFormEditor == null) {
            return;
        }
        IFormPage oldPage = this.formPage;
        this.formPage = this.mtjFormEditor.getActivePageInstance();
        if (this.formPage != null) {
            this.updateActions();
            if (oldPage != null && !oldPage.isEditor() && !this.formPage.isEditor()) {
                this.getActionBars().updateActionBars();
            }
        }
    }

    public void updateActions() {
        this.saveAction.update();
        this.revertAction.update();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.mtjFormEditor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
        }
    }

    private void addGlobalAction(String id) {
        GlobalAction action = new GlobalAction(id);
        this.addGlobalAction(id, action);
    }

    private void addGlobalAction(String id, Action action) {
        this.globalActions.put(id, action);
        this.getActionBars().setGlobalActionHandler(id, (IAction)action);
    }

    protected ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = this.getPage().getWorkbenchWindow().getWorkbench().getSharedImages();
        }
        return this.sharedImages;
    }

    protected void makeActions() {
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.addGlobalAction(ActionFactory.CUT.getId(), this.cutAction);
        this.addGlobalAction(ActionFactory.COPY.getId(), this.copyAction);
        this.addGlobalAction(ActionFactory.PASTE.getId(), this.pasteAction);
        this.addGlobalAction(ActionFactory.DELETE.getId());
        this.addGlobalAction(ActionFactory.UNDO.getId());
        this.addGlobalAction(ActionFactory.REDO.getId());
        this.addGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.addGlobalAction(ActionFactory.FIND.getId());
        this.addGlobalAction(IDEActionFactory.BOOKMARK.getId());
        this.saveAction = new SaveAction();
        this.saveAction.setText(MTJUIMessages.MTJFormEditorContributor_saveAction_text);
        this.revertAction = new RevertAction();
        this.revertAction.setText(MTJUIMessages.MTJFormEditorContributor_revertAction_text);
        this.addGlobalAction(ActionFactory.REVERT.getId(), this.revertAction);
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String id) {
            super(id);
            this.setEnabled(false);
        }

        public boolean isEditable() {
            if (MTJFormEditorContributor.this.mtjFormEditor == null) {
                return false;
            }
            IBaseModel model = MTJFormEditorContributor.this.mtjFormEditor.getAggregateModel();
            return model instanceof IEditable ? ((IEditable)model).isEditable() : false;
        }

        public void selectionChanged(ISelection selection) {
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super(ActionFactory.COPY.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_copyAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor.canCopy(selection));
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super(ActionFactory.CUT.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_cutAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && MTJFormEditorContributor.this.mtjFormEditor.canCut(selection));
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String id) {
            this.id = id;
        }

        public void run() {
            MTJFormEditorContributor.this.mtjFormEditor.performGlobalAction(this.id);
            MTJFormEditorContributor.this.updateSelectableActions(MTJFormEditorContributor.this.mtjFormEditor.getSelection());
        }

        public void update() {
            MTJFormEditorContributor.this.getActionBars().updateActionBars();
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super(ActionFactory.PASTE.getId());
            this.setText(MTJUIMessages.MTJFormEditorContributor_pasteAction_text);
            this.setImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(MTJFormEditorContributor.this.getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && MTJFormEditorContributor.this.mtjFormEditor.canPasteFromClipboard());
        }
    }

    class RevertAction
    extends Action
    implements IUpdate {
        public void run() {
            if (MTJFormEditorContributor.this.mtjFormEditor != null) {
                MTJFormEditorContributor.this.mtjFormEditor.doRevert();
            }
        }

        public void update() {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor != null ? MTJFormEditorContributor.this.mtjFormEditor.isDirty() : false);
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (MTJFormEditorContributor.this.mtjFormEditor != null) {
                MTJUIPlugin.getActivePage().saveEditor((IEditorPart)MTJFormEditorContributor.this.mtjFormEditor, false);
            }
        }

        public void update() {
            this.setEnabled(MTJFormEditorContributor.this.mtjFormEditor != null ? MTJFormEditorContributor.this.mtjFormEditor.isDirty() : false);
        }
    }
}

