/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mtj.internal.ui.IPreferenceConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.EmptyOutlinePage;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.ToggleLinkWithEditorAction;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MTJMultiPageContentOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider,
ISelectionChangedListener,
IPreferenceConstants {
    private IActionBars actionBars;
    private ISortableContentOutlinePage currentPage;
    private MTJFormEditor editor;
    private ISortableContentOutlinePage emptyPage;
    private ArrayList<ISelectionChangedListener> listeners;
    private PageBook pagebook;
    private ISelection selection;
    private boolean sortingOn;

    public MTJMultiPageContentOutline(MTJFormEditor editor) {
        this.editor = editor;
        this.listeners = new ArrayList();
        this.sortingOn = MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("PDEMultiPageContentOutline.SortingAction.isChecked");
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
        this.pagebook = null;
        this.listeners = null;
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setActionBars(IActionBars actionBars) {
        this.actionBars = actionBars;
        this.registerToolbarActions(actionBars);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    public void setPageActive(ISortableContentOutlinePage page) {
        if (page == null) {
            page = this.getEmptyPage();
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener(this);
        }
        page.sort(this.sortingOn);
        page.addSelectionChangedListener(this);
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            page.setActionBars(this.getActionBars());
            control = page.getControl();
        }
        this.pagebook.showPage(control);
        this.currentPage = page;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(e);
            ++i;
        }
    }

    private ISortableContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new ToggleLinkWithEditorAction(this.editor));
            toolBarManager.add((IAction)new SortingAction());
        }
    }

    class SortingAction
    extends Action {
        public SortingAction() {
            this.setText(MTJUIMessages.MTJMultiPageContentOutline_sortingAction_text);
            this.setImageDescriptor(MTJUIPluginImages.DESC_ALPHAB_SORT_CO);
            this.setDisabledImageDescriptor(MTJUIPluginImages.DESC_ALPHAB_SORT_CO_DISABLED);
            this.setToolTipText(MTJUIMessages.MTJMultiPageContentOutline_toolTipText);
            this.setDescription(MTJUIMessages.MTJMultiPageContentOutline_description);
            this.setChecked(MTJMultiPageContentOutline.this.sortingOn);
        }

        public void run() {
            this.setChecked(this.isChecked());
            this.valueChanged(this.isChecked());
        }

        private void valueChanged(boolean on) {
            MTJMultiPageContentOutline.this.sortingOn = on;
            if (MTJMultiPageContentOutline.this.currentPage != null) {
                MTJMultiPageContentOutline.this.currentPage.sort(on);
            }
            MTJUIPlugin.getDefault().getPreferenceStore().setValue("MTJMultiPageContentOutline.SortingAction.isChecked", on);
        }
    }
}

