/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.util.SourceViewerDecorator;
import org.eclipse.swt.widgets.Composite;

public class MTJProjectionViewer
extends SourceViewerDecorator {
    public static final int QUICK_OUTLINE = 513;
    private boolean fIsQuickOutlineEnabled;
    private IInformationPresenter fOutlinePresenter;

    public MTJProjectionViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, boolean isQuickOutlineEnabled) {
        super((SourceViewer)new ProjectionViewer(parent, ruler, overviewRuler, showsAnnotationOverview, styles));
        this.fIsQuickOutlineEnabled = isQuickOutlineEnabled;
    }

    public boolean canDoOperation(int operation) {
        if (operation == 513) {
            return this.fOutlinePresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        super.configure(configuration);
        if (this.fIsQuickOutlineEnabled && configuration instanceof ChangeAwareSourceViewerConfiguration) {
            ChangeAwareSourceViewerConfiguration sourceConfiguration = (ChangeAwareSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = sourceConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
        }
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        if (operation == 513) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
            return;
        }
        super.doOperation(operation);
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        super.unconfigure();
    }
}

