/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJFormTextEditorContributor;
import org.eclipse.mtj.internal.ui.editor.SourceOutlinePage;
import org.eclipse.mtj.internal.ui.editor.actions.FormatAction;
import org.eclipse.mtj.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.mtj.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.mtj.internal.ui.editor.text.MTJSelectAnnotationRulerAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public abstract class MTJSourcePage
extends TextEditor
implements IFormPage,
IGotoMarker,
ISelectionChangedListener,
IOutlineContentCreator,
IOutlineSelectionHandler {
    private static String RES_BUNDLE_LOCATION = "org.eclipse.mtj.internal.ui.editor.text.ConstructedMTJEditorMessages";
    private static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(RES_BUNDLE_LOCATION);
    private Control fControl;
    private MTJFormEditor fEditor;
    protected MTJSourcePageChangedListener fEditorSelectionChangedListener;
    private String fId;
    private int fIndex;
    private InputContext fInputContext;
    protected ISortableContentOutlinePage fOutlinePage;
    private Object fSelection;
    protected ISelectionChangedListener fOutlineSelectionChangedListener;

    public static ResourceBundle getBundleForConstructedKeys() {
        return fgBundleForConstructedKeys;
    }

    public MTJSourcePage(MTJFormEditor editor, String id, String title) {
        this.fId = id;
        this.initialize(editor);
        IPreferenceStore[] stores = new IPreferenceStore[]{MTJUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public IDocumentRange adaptRange(IDocumentRange range) {
        return range;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public abstract void refreshMarkStatus();

    public ViewerComparator createDefaultOutlineComparator() {
        return null;
    }

    public abstract ViewerComparator createOutlineComparator();

    public abstract ITreeContentProvider createOutlineContentProvider();

    public abstract ILabelProvider createOutlineLabelProvider();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.fControl = children[children.length - 1];
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.isSelectionListener()) {
            this.getEditor().getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IShowInTargetList.class && this.fEditor != null && this.fEditor.getEditorInput() instanceof IFileEditorInput) {
            return this.getShowInTargetList();
        }
        return super.getAdapter(adapter);
    }

    public ISortableContentOutlinePage getContentOutline() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public FormEditor getEditor() {
        return this.fEditor;
    }

    public String getId() {
        return this.fId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public InputContext getInputContext() {
        return this.fInputContext;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public Object getOutlineInput() {
        return this.getInputContext().getModel();
    }

    public Control getPartControl() {
        return this.fControl;
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        return null;
    }

    public Object getSelection() {
        return this.fSelection;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void initialize(FormEditor editor) {
        this.fEditor = (MTJFormEditor)editor;
    }

    public boolean isActive() {
        return this.equals(this.fEditor.getActivePageInstance());
    }

    public boolean isEditor() {
        return true;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.getSelectionProvider()) {
            return;
        }
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            this.setSelectedObject(structuredSel.getFirstElement());
        } else if (sel instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)sel;
            this.setSelectedObject(this.getRangeElement(textSel.getOffset(), false));
        } else {
            this.fSelection = null;
        }
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    public void setActive(boolean active) {
        this.fInputContext.setSourceEditingMode(active);
    }

    public void setHighlightRange(IDocumentRange range, boolean moveCursor) {
        int offset = range.getOffset();
        if (offset == -1) {
            this.resetHighlightRange();
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int length = range.getLength();
        this.setHighlightRange(offset, length == -1 ? 1 : length, moveCursor);
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public void setInputContext(InputContext inputContext) {
        this.fInputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public void setSelectedRange(IDocumentRange range, boolean fullNodeSelection) {
        int offset;
        int length;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        if (range instanceof IDocumentElementNode && !fullNodeSelection) {
            length = ((IDocumentElementNode)range).getXMLTagName().length();
            offset = range.getOffset() + 1;
        } else {
            length = range.getLength();
            offset = range.getOffset();
        }
        sourceViewer.setSelectedRange(offset, length);
    }

    public void synchronizeOutlinePage() {
        int current_offset = this.getSourceViewer().getSelectedRange().x;
        this.synchronizeOutlinePage(current_offset);
    }

    public abstract void updateSelection(Object var1);

    public void updateSelection(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)sel;
            this.updateSelection(structuredSelection.getFirstElement());
        }
    }

    private void createContentAssistAction() {
        ContentAssistAction contentAssist = new ContentAssistAction(MTJSourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        contentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssist", (IAction)contentAssist);
        this.markAsStateDependentAction("ContentAssist", true);
    }

    private void createQuickOutlineAction() {
        TextOperationAction action = new TextOperationAction(MTJSourcePage.getBundleForConstructedKeys(), "QuickOutline.", (ITextEditor)this, 513, true);
        action.setActionDefinitionId("org.eclipse.mtj.ui.quickOutline");
        action.setText(MTJUIMessages.MTJSourcePage_quickOutlineAction_text);
        action.setId("org.eclipse.mtj.ui.quickOutline");
        action.setImageDescriptor(MTJUIPluginImages.DESC_OVERVIEW_OBJ);
        this.setAction("org.eclipse.mtj.ui.quickOutline", (IAction)action);
    }

    private void synchronizeOutlinePage(IDocumentRange rangeElement) {
        this.updateHighlightRange(rangeElement);
        this.updateOutlinePageSelection(rangeElement);
    }

    protected void createActions() {
        MTJFormEditorContributor contributor;
        super.createActions();
        MTJSelectAnnotationRulerAction action = new MTJSelectAnnotationRulerAction(MTJSourcePage.getBundleForConstructedKeys(), "MTJSelectAnnotationRulerAction.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)action);
        MTJFormEditorContributor mTJFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof MTJFormTextEditorContributor) {
            MTJFormTextEditorContributor textContributor = (MTJFormTextEditorContributor)contributor;
            this.setAction("org.eclipse.mtj.ui.actions.Open", (IAction)textContributor.getHyperlinkAction());
            this.setAction("org.eclipse.mtj.ui.actions.Format", (IAction)textContributor.getFormatAction());
            if (textContributor.supportsContentAssist()) {
                this.createContentAssistAction();
            }
        }
        this.createQuickOutlineAction();
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        SourceOutlinePage sourceOutlinePage = new SourceOutlinePage((MTJFormEditor)this.getEditor(), (IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
        this.fOutlinePage = sourceOutlinePage;
        this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MTJSourcePage.this.updateSelection(event);
            }
        };
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
        this.fEditorSelectionChangedListener = new MTJSourcePageChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.fOutlinePage;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MTJFormEditorContributor contributor;
        MTJFormEditorContributor mTJFormEditorContributor = contributor = this.fEditor == null ? null : this.fEditor.getContributor();
        if (contributor instanceof MTJFormTextEditorContributor) {
            MTJFormTextEditorContributor textContributor = (MTJFormTextEditorContributor)contributor;
            HyperlinkAction action = textContributor.getHyperlinkAction();
            menu.add((IAction)action);
            FormatAction formatManifestAction = textContributor.getFormatAction();
            if (this.isEditable() && formatManifestAction != null && formatManifestAction.isEnabled()) {
                menu.add((IAction)formatManifestAction);
            }
        }
        super.editorContextMenuAboutToShow(menu);
    }

    protected IDocumentRange findNode(IDocumentElementNode node, int offset, boolean searchChildren) {
        return this.findNode(new Object[]{node}, offset, searchChildren);
    }

    protected IDocumentRange findNode(Object[] nodes, int offset, boolean searchChildren) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node2 = objectArray[n2];
            IDocumentElementNode node = (IDocumentElementNode)node2;
            if (node.getOffset() <= offset && offset < node.getOffset() + node.getLength()) {
                IDocumentTextNode textNode;
                if (!searchChildren) {
                    return node;
                }
                if (node.getOffset() < offset && offset <= node.getOffset() + node.getXMLTagName().length() + 1) {
                    return node;
                }
                IDocumentAttributeNode[] attrs = node.getNodeAttributes();
                if (attrs != null) {
                    IDocumentAttributeNode[] iDocumentAttributeNodeArray = attrs;
                    int n3 = attrs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDocumentAttributeNode attr = iDocumentAttributeNodeArray[n4];
                        if (attr.getNameOffset() <= offset && offset <= attr.getValueOffset() + attr.getValueLength()) {
                            return attr;
                        }
                        ++n4;
                    }
                }
                if ((textNode = node.getTextNode()) != null && textNode.getOffset() <= offset && offset < textNode.getOffset() + textNode.getLength()) {
                    return textNode;
                }
                IDocumentElementNode[] children = node.getChildNodes();
                if (children != null) {
                    IDocumentElementNode[] iDocumentElementNodeArray = children;
                    int n5 = children.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IDocumentElementNode element = iDocumentElementNodeArray[n6];
                        if (element.getOffset() <= offset && offset < element.getOffset() + element.getLength()) {
                            return this.findNode(element, offset, searchChildren);
                        }
                        ++n6;
                    }
                }
                return node;
            }
            ++n2;
        }
        return null;
    }

    protected IDocumentRange findRange() {
        return null;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.fEditor.fireSaveNeeded(this.getEditorInput(), true);
        }
        super.firePropertyChange(type);
    }

    protected IShowInTargetList getShowInTargetList() {
        return new IShowInTargetList(){

            public String[] getShowInTargetIds() {
                return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
            }
        };
    }

    protected void handleSelectionChangedSourcePage(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            int offset = textSel.getOffset();
            IDocumentRange rangeElement = this.getRangeElement(offset, false);
            this.setSelectedObject(rangeElement);
            this.synchronizeOutlinePage(rangeElement);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.mtj.ui.mtjEditorContext"});
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected void setSelectedObject(Object selectedObject) {
        this.fSelection = selectedObject;
    }

    protected void synchronizeOutlinePage(int offset) {
        IDocumentRange rangeElement = this.getRangeElement(offset, false);
        this.synchronizeOutlinePage(rangeElement);
    }

    protected void updateHighlightRange(IDocumentRange rangeElement) {
        if (rangeElement != null) {
            this.setHighlightRange(rangeElement, false);
        } else {
            this.resetHighlightRange();
        }
    }

    protected void updateOutlinePageSelection(Object rangeElement) {
        if (MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked")) {
            if (!(this.fOutlinePage instanceof SourceOutlinePage)) {
                return;
            }
            SourceOutlinePage outlinePage = (SourceOutlinePage)this.fOutlinePage;
            outlinePage.removeAllSelectionChangedListeners();
            if (rangeElement != null) {
                outlinePage.setSelection((ISelection)new StructuredSelection(rangeElement));
            } else {
                outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            outlinePage.addAllSelectionChangedListeners();
        }
    }

    public class MTJSourcePageChangedListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            MTJSourcePage.this.handleSelectionChangedSourcePage(event);
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider != null) {
                if (selectionProvider instanceof IPostSelectionProvider) {
                    IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                    provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
                } else {
                    selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        }
    }
}

