/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.editor.GenericSourcePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class MultiSourceEditor
extends MTJFormEditor {
    protected void addSourcePage(String contextId) {
        InputContext context = this.inputContextManager.findContext(contextId);
        if (context == null) {
            return;
        }
        if (this.findPage(contextId) != null) {
            return;
        }
        MTJSourcePage sourcePage = this.createSourcePage(this, contextId, context.getInput().getName(), context.getId());
        sourcePage.setInputContext(context);
        try {
            this.addPage((IEditorPart)sourcePage, context.getInput());
        }
        catch (PartInitException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    protected MTJSourcePage createSourcePage(MTJFormEditor editor, String title, String name, String contextId) {
        return new GenericSourcePage(editor, title, name);
    }

    protected void removePage(String pageId) {
        IFormPage page = this.findPage(pageId);
        if (page == null) {
            return;
        }
        if (!page.isDirty()) {
            this.removePage(page.getIndex());
            if (!page.isEditor()) {
                page.dispose();
            }
        }
    }
}

