/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.IReconcilingParticipant;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJOutlinePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;

public class SourceOutlinePage
extends MTJOutlinePage
implements IReconcilingParticipant,
ISortableContentOutlinePage {
    private IContentProvider contentProvider;
    private ViewerComparator defaultComparator;
    private IBaseLabelProvider labelProvider;
    private ArrayList<ISelectionChangedListener> listenerList;
    protected IEditingModel model;
    private boolean sorted;
    private ViewerComparator viewerComparator;
    TreeViewer viewer;

    public SourceOutlinePage(MTJFormEditor editor, IEditingModel model, IBaseLabelProvider lProvider, IContentProvider cProvider, ViewerComparator defaultComparator, ViewerComparator comparator) {
        super(editor);
        this.model = model;
        this.labelProvider = lProvider;
        this.contentProvider = cProvider;
        this.defaultComparator = defaultComparator;
        this.viewerComparator = comparator;
        this.listenerList = new ArrayList();
    }

    public void addAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        int i = 0;
        while (i < this.listenerList.size()) {
            super.addSelectionChangedListener(this.listenerList.get(i));
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.add(listener);
        super.addSelectionChangedListener(listener);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setLabelProvider(this.labelProvider);
        if (this.sorted) {
            this.viewer.setComparator(this.viewerComparator);
        } else {
            this.viewer.setComparator(this.defaultComparator);
        }
        this.viewer.setInput((Object)this.model);
        this.viewer.expandAll();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void reconciled(IDocument document) {
        final Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                control.setRedraw(false);
                SourceOutlinePage.this.removeAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().refresh();
                SourceOutlinePage.this.addAllSelectionChangedListeners();
                SourceOutlinePage.this.getTreeViewer().expandAll();
                control.setRedraw(true);
            }
        });
    }

    public void removeAllSelectionChangedListeners() {
        if (this.isViewerDefined()) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        int i = 0;
        while (i < this.listenerList.size()) {
            super.removeSelectionChangedListener(this.listenerList.get(i));
            ++i;
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove(listener);
        super.removeSelectionChangedListener(listener);
    }

    public void sort(boolean sorting) {
        this.sorted = sorting;
        if (this.isViewerDefined()) {
            if (sorting) {
                this.viewer.setComparator(this.viewerComparator);
            } else {
                this.viewer.setComparator(this.defaultComparator);
            }
        }
    }

    private boolean isViewerDefined() {
        if (this.viewer == null) {
            return false;
        }
        return !this.viewer.getTree().isDisposed();
    }
}

