/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.editor.IMTJDragParticipant;
import org.eclipse.mtj.internal.ui.editor.IMTJDropParticipant;
import org.eclipse.mtj.internal.ui.editor.MTJDragAdapter;
import org.eclipse.mtj.internal.ui.editor.MTJDropAdapter;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJSection;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.parts.StructuredViewerPart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerSection
extends MTJSection
implements IMTJDragParticipant,
IMTJDropParticipant {
    private boolean fDoSelection;
    private MTJDragAdapter fDragAdapter;
    private MTJDropAdapter fDropAdapter;
    protected StructuredViewerPart fViewerPart;

    public StructuredViewerSection(MTJFormPage formPage, Composite parent, int style, boolean titleBar, String[] buttonLabels) {
        super(formPage, parent, style, titleBar);
        this.fViewerPart = this.createViewerPart(buttonLabels);
        this.fViewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = formPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
        this.fDoSelection = true;
    }

    public StructuredViewerSection(MTJFormPage formPage, Composite parent, int style, String[] buttonLabels) {
        this(formPage, parent, style, true, buttonLabels);
    }

    public boolean canDragCopy(Object[] sourceObjects) {
        return false;
    }

    public boolean canDragLink(Object[] sourceObjects) {
        return false;
    }

    public boolean canDragMove(Object[] sourceObjects) {
        return false;
    }

    public boolean canDropCopy(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return false;
    }

    public boolean canDropLink(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return false;
    }

    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        ISelection selection = this.getViewerSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() > 1) {
            return false;
        }
        Object target = ssel.getFirstElement();
        ModelDataTransfer modelTransfer = ModelDataTransfer.getInstance();
        Object[] objects = (Object[])clipboard.getContents((Transfer)modelTransfer);
        if (objects != null && objects.length > 0) {
            return this.canPaste(target, objects);
        }
        return false;
    }

    public void doDragRemove(Object[] sourceObjects) {
    }

    public void doDropCopy(Object targetObject, Object[] sourceObjects, int targetLocation) {
    }

    public void doDropLink(Object targetObject, Object[] sourceObjects, int targetLocation) {
    }

    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
    }

    public StructuredViewerPart getStructuredViewerPart() {
        return this.fViewerPart;
    }

    public int getSupportedDNDOperations() {
        return 2;
    }

    public void setFocus() {
        this.fViewerPart.getControl().setFocus();
    }

    protected void buttonSelected(int index) {
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    protected boolean canSelect() {
        return this.fDoSelection;
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, span));
        return container;
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fViewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                StructuredViewerSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.fViewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
        if (this.isDragAndDropEnabled()) {
            this.initializeDragAndDrop();
        } else {
            this.fDragAdapter = null;
            this.fDropAdapter = null;
        }
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        ISelection selection = this.getViewerSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() > 1) {
            return;
        }
        Object target = ssel.getFirstElement();
        Clipboard clipboard = this.getPage().getMTJEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(target, objects);
        }
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    protected void doSelect(boolean select) {
        this.fDoSelection = select;
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected int getArrayIndex(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(object)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Object[] getDragSourceObjects() {
        if (!this.isDragAndDropEnabled()) {
            return null;
        }
        if (this.fDragAdapter == null) {
            return null;
        }
        return this.fDragAdapter.getSourceObjects();
    }

    protected Transfer[] getDragTransfers() {
        return new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
    }

    protected Transfer[] getDropTransfers() {
        return this.getDragTransfers();
    }

    protected int getNewSelectionIndex(int thisIndex, int length) {
        if (thisIndex == length - 1) {
            return thisIndex - 1;
        }
        return thisIndex + 1;
    }

    protected ISelection getViewerSelection() {
        return this.fViewerPart.getViewer().getSelection();
    }

    protected void initializeDragAndDrop() {
        if (!this.isEditable()) {
            return;
        }
        if (this.fViewerPart == null) {
            return;
        }
        StructuredViewer viewer = this.fViewerPart.getViewer();
        if (viewer == null) {
            return;
        }
        this.fDragAdapter = new MTJDragAdapter(this);
        this.fDropAdapter = new MTJDropAdapter((Viewer)viewer, this, this.fDragAdapter);
        int dragOperations = this.getSupportedDNDOperations();
        viewer.addDragSupport(dragOperations, this.getDragTransfers(), (DragSourceListener)this.fDragAdapter);
        int dropOperations = dragOperations | 0x10;
        viewer.addDropSupport(dropOperations, this.getDropTransfers(), (DropTargetListener)this.fDropAdapter);
    }

    protected boolean isDragAndDropEnabled() {
        return false;
    }
}

