/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;

public class CollapseAction
extends Action {
    private int fExpandToLevel;
    private Object fTreeObject;
    private AbstractTreeViewer fTreeViewer;

    public CollapseAction(AbstractTreeViewer viewer, String tooltipText) {
        super(tooltipText, 1);
        this.fExpandToLevel = 0;
        this.fTreeObject = null;
        this.initialize(viewer, tooltipText);
    }

    public CollapseAction(AbstractTreeViewer viewer, String tooltipText, int expandToLevel, Object treeObject) {
        super(tooltipText, 1);
        this.fExpandToLevel = expandToLevel;
        this.fTreeObject = treeObject;
        this.initialize(viewer, tooltipText);
    }

    public void run() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fTreeObject != null && this.fExpandToLevel > 0) {
            this.fTreeViewer.getControl().setRedraw(false);
            this.fTreeViewer.collapseAll();
            this.fTreeViewer.expandToLevel(this.fTreeObject, 1);
            this.fTreeViewer.getControl().setRedraw(true);
        } else {
            this.fTreeViewer.collapseAll();
        }
    }

    private void initialize(AbstractTreeViewer viewer, String tooltipText) {
        this.setToolTipText(tooltipText);
        this.setImageDescriptor(MTJUIPluginImages.DESC_COLLAPSE_ALL);
        this.fTreeViewer = viewer;
    }
}

