/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;

public class HyperlinkAction
extends Action
implements MouseListener,
KeyListener {
    protected IHyperlinkDetector fDetector;
    protected IHyperlink fLink;
    protected StyledText fStyledText;

    public HyperlinkAction() {
        this.setImageDescriptor(MTJUIPluginImages.DESC_LINK_OBJ);
        this.setEnabled(false);
    }

    public boolean detectHyperlink() {
        this.fLink = null;
        if (!this.hasDetector() || this.isTextDisposed()) {
            return false;
        }
        Point p = this.fStyledText.getSelection();
        IHyperlink[] links = this.fDetector.detectHyperlinks(null, (IRegion)new Region(p.x, p.y - p.x), false);
        if (links == null || links.length == 0) {
            return false;
        }
        this.fLink = links[0];
        return true;
    }

    public void generateActionText() {
        String text = MTJUIMessages.HyperlinkAction_text;
        this.setText(text);
        this.setToolTipText(text);
    }

    public IHyperlink getHyperLink() {
        return this.fLink;
    }

    public void keyPressed(KeyEvent e) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    public void run() {
        if (this.fLink != null) {
            this.fLink.open();
        }
    }

    public void setTextEditor(ITextEditor editor) {
        StyledText newText;
        StyledText styledText = newText = editor instanceof MTJSourcePage ? ((MTJSourcePage)editor).getViewer().getTextWidget() : null;
        if (this.fStyledText != null && this.fStyledText.equals(newText)) {
            return;
        }
        this.removeListeners();
        this.fStyledText = newText;
        this.fDetector = editor instanceof MTJSourcePage ? (IHyperlinkDetector)((MTJSourcePage)editor).getAdapter(IHyperlinkDetector.class) : null;
        this.addListeners();
        this.setEnabled(this.detectHyperlink());
        this.generateActionText();
    }

    private boolean isTextDisposed() {
        return this.fStyledText == null || this.fStyledText.isDisposed();
    }

    protected void addListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.addMouseListener((MouseListener)this);
        this.fStyledText.addKeyListener((KeyListener)this);
    }

    protected boolean hasDetector() {
        return this.fDetector != null;
    }

    protected void removeListeners() {
        if (!this.hasDetector() || this.isTextDisposed()) {
            return;
        }
        this.fStyledText.removeMouseListener((MouseListener)this);
        this.fStyledText.removeKeyListener((KeyListener)this);
    }
}

