/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.context;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.IEditable;
import org.eclipse.mtj.internal.core.IModelChangeProvider;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.util.PropertiesUtil;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJStorageDocumentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputContext {
    private IDocumentProvider fDocumentProvider;
    private MTJFormEditor fEditor;
    private IEditorInput fEditorInput;
    private IElementStateListener fElementListener;
    private boolean fIsSourceMode;
    private IBaseModel fModel;
    private IModelChangedListener fModelListener;
    private boolean fMustSynchronize;
    private boolean fPrimary;
    private boolean fValidated;
    protected ArrayList<TextEdit> fEditOperations = new ArrayList();

    protected static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }

    protected static void insert(TextEdit parent, TextEdit edit) {
        TextEdit[] children;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            if (edit instanceof MoveSourceEdit) {
                parent.addChild((TextEdit)((MoveSourceEdit)edit).getTargetEdit());
            }
            return;
        }
        TextEdit[] textEditArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit child = textEditArray[n2];
            if (InputContext.covers(child, edit)) {
                InputContext.insert(child, edit);
                return;
            }
            ++n2;
        }
        int i = children.length - 1;
        while (i >= 0) {
            TextEdit child = children[i];
            if (InputContext.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
        if (edit instanceof MoveSourceEdit) {
            parent.addChild((TextEdit)((MoveSourceEdit)edit).getTargetEdit());
        }
    }

    public InputContext(MTJFormEditor editor, IEditorInput input, boolean primary) {
        this.fEditor = editor;
        this.fEditorInput = input;
        this.setPrimary(primary);
    }

    public void dispose() {
        IAnnotationModel amodel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (amodel != null) {
            amodel.disconnect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.removeElementStateListener(this.fElementListener);
        this.fDocumentProvider.disconnect((Object)this.fEditorInput);
        if (this.fModelListener != null && this.fModel instanceof IModelChangeProvider) {
            ((IModelChangeProvider)this.fModel).removeModelChangedListener(this.fModelListener);
        }
        if (this.fModel != null) {
            this.fModel.dispose();
        }
    }

    public void doRevert() {
        this.fMustSynchronize = true;
        this.synchronizeModelIfNeeded();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IDocument doc = this.fDocumentProvider.getDocument((Object)this.fEditorInput);
            this.fDocumentProvider.aboutToChange((Object)this.fEditorInput);
            this.flushModel(doc);
            this.fDocumentProvider.saveDocument(monitor, (Object)this.fEditorInput, doc, true);
            this.fDocumentProvider.changed((Object)this.fEditorInput);
            this.fValidated = false;
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    public void doSaveAs(IProgressMonitor monitor) throws Exception {
        Shell shell = this.getEditor().getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile file = null;
        if (this.fEditorInput instanceof IFileEditorInput) {
            file = ((IFileEditorInput)this.fEditorInput).getFile();
            dialog.setOriginalFile(file);
        }
        dialog.create();
        if (this.fDocumentProvider.isDeleted((Object)this.fEditorInput) && file != null) {
            String message = NLS.bind((String)MTJUIMessages.InputContext_doSaveAs_fileNotExist, (Object)file.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            this.handleSaveAs(monitor, path);
        }
    }

    public void flushEditorInput() {
        if (this.fEditOperations.size() > 0) {
            IDocument doc = this.fDocumentProvider.getDocument((Object)this.fEditorInput);
            this.fDocumentProvider.aboutToChange((Object)this.fEditorInput);
            this.flushModel(doc);
            this.fDocumentProvider.changed((Object)this.fEditorInput);
            this.fValidated = false;
        } else if (this.fModel instanceof IEditable && ((IEditable)this.fModel).isDirty()) {
            ((IEditable)this.fModel).setDirty(false);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fDocumentProvider;
    }

    public MTJFormEditor getEditor() {
        return this.fEditor;
    }

    public abstract String getId();

    public IEditorInput getInput() {
        return this.fEditorInput;
    }

    public String getLineDelimiter() {
        IDocument document;
        if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)this.fEditorInput)) != null) {
            return TextUtilities.getDefaultLineDelimiter((IDocument)document);
        }
        return System.getProperty("line.separator");
    }

    public IBaseModel getModel() {
        return this.fModel;
    }

    public boolean isInSourceMode() {
        return this.fIsSourceMode;
    }

    public boolean isModelCorrect() {
        this.synchronizeModelIfNeeded();
        return this.fModel != null ? this.fModel.isValid() : false;
    }

    public boolean isPrimary() {
        return this.fPrimary;
    }

    public boolean isValidated() {
        return this.fValidated;
    }

    public boolean matches(IResource resource) {
        IFileEditorInput finput;
        IFile file;
        return this.fEditorInput instanceof IFileEditorInput && (file = (finput = (IFileEditorInput)this.fEditorInput).getFile()).equals((Object)resource);
    }

    public boolean mustSave() {
        if (!this.fIsSourceMode && this.fModel instanceof IEditable && ((IEditable)this.fModel).isDirty()) {
            return true;
        }
        return this.fEditOperations.size() > 0 || this.fDocumentProvider.canSaveDocument((Object)this.fEditorInput);
    }

    public void setPrimary(boolean primary) {
        this.fPrimary = primary;
    }

    public boolean setSourceEditingMode(boolean sourceMode) {
        this.fIsSourceMode = sourceMode;
        if (sourceMode) {
            this.flushModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            this.fMustSynchronize = true;
            return true;
        }
        return this.synchronizeModelIfNeeded();
    }

    public void setValidated(boolean validated) {
        this.fValidated = validated;
    }

    public synchronized boolean validateEdit() {
        IFile file;
        if (!this.fValidated && this.fEditorInput instanceof IFileEditorInput && (file = ((IFileEditorInput)this.fEditorInput).getFile()).isReadOnly()) {
            Shell shell = this.fEditor.getEditorSite().getShell();
            IStatus validateStatus = MTJUIPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
            this.fValidated = true;
            if (validateStatus.getSeverity() != 0) {
                ErrorDialog.openError((Shell)shell, (String)this.fEditor.getTitle(), null, (IStatus)validateStatus);
            }
            return validateStatus.getSeverity() == 0;
        }
        return true;
    }

    private IDocumentProvider createDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return new ForwardingDocumentProvider(this.getPartitionName(), this.getDocumentSetupParticipant(), MTJUIPlugin.getDefault().getTextFileDocumentProvider());
        }
        return new MTJStorageDocumentProvider(this.getDocumentSetupParticipant());
    }

    private WorkspaceModifyOperation createWorkspaceModifyOperation(final IEditorInput newInput) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                InputContext.this.fDocumentProvider.saveDocument(monitor, (Object)newInput, InputContext.this.fDocumentProvider.getDocument((Object)InputContext.this.fEditorInput), true);
            }
        };
        return operation;
    }

    private void deinitializeDocumentProvider() {
        IAnnotationModel amodel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (amodel != null) {
            amodel.disconnect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.removeElementStateListener(this.fElementListener);
        this.fDocumentProvider.disconnect((Object)this.fEditorInput);
    }

    private void handleSaveAs(IProgressMonitor monitor, IPath path) throws Exception, CoreException, InterruptedException, InvocationTargetException {
        if (path == null) {
            monitor.setCanceled(true);
            throw new Exception(MTJUIMessages.InputContext_saveAs_noLocation);
        }
        IWorkspace workspace = MTJCore.getWorkspace();
        IFile newFile = workspace.getRoot().getFile(path);
        FileEditorInput newInput = new FileEditorInput(newFile);
        this.fDocumentProvider.aboutToChange((Object)newInput);
        this.flushModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this.createWorkspaceModifyOperation((IEditorInput)newInput));
                monitor.setCanceled(false);
                this.updateInput((IEditorInput)newInput);
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
                throw e;
            }
            catch (InvocationTargetException e) {
                monitor.setCanceled(true);
                throw e;
            }
        }
        finally {
            this.fDocumentProvider.changed((Object)newInput);
        }
    }

    private void initializeDocumentProvider() throws CoreException {
        this.fDocumentProvider.connect((Object)this.fEditorInput);
        IAnnotationModel amodel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput);
        if (amodel != null) {
            amodel.connect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
        }
        this.fDocumentProvider.addElementStateListener(this.fElementListener);
    }

    private boolean synchronizeModelIfNeeded() {
        if (this.fMustSynchronize) {
            boolean result = this.synchronizeModel(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            this.fMustSynchronize = false;
            return result;
        }
        return true;
    }

    private void updateInput(IEditorInput newInput) throws CoreException {
        this.deinitializeDocumentProvider();
        this.fEditorInput = newInput;
        this.initializeDocumentProvider();
    }

    protected abstract void addTextEditOperation(ArrayList<TextEdit> var1, IModelChangedEvent var2);

    protected void create() {
        this.fDocumentProvider = this.createDocumentProvider(this.fEditorInput);
        try {
            IAnnotationModel amodel;
            this.fDocumentProvider.connect((Object)this.fEditorInput);
            this.fModel = this.createModel(this.fEditorInput);
            if (this.fModel instanceof IModelChangeProvider) {
                this.fModelListener = new IModelChangedListener(){

                    public void modelChanged(IModelChangedEvent e) {
                        if (e.getChangeType() != 99) {
                            IModelChangeProvider provider;
                            if (!InputContext.this.fEditor.getLastDirtyState()) {
                                InputContext.this.fEditor.fireSaveNeeded(InputContext.this.fEditorInput, true);
                            }
                            if ((provider = e.getChangeProvider()) instanceof IEditingModel && ((IEditingModel)provider).isDirty()) {
                                InputContext.this.addTextEditOperation(InputContext.this.fEditOperations, e);
                            }
                        }
                    }
                };
                ((IModelChangeProvider)this.fModel).addModelChangedListener(this.fModelListener);
            }
            if ((amodel = this.fDocumentProvider.getAnnotationModel((Object)this.fEditorInput)) != null) {
                amodel.connect(this.fDocumentProvider.getDocument((Object)this.fEditorInput));
            }
            this.fElementListener = new ElementListener();
            this.fDocumentProvider.addElementStateListener(this.fElementListener);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    protected abstract IBaseModel createModel(IEditorInput var1) throws CoreException;

    protected void flushModel(IDocument doc) {
        boolean flushed = true;
        if (this.fEditOperations.size() > 0) {
            try {
                MultiTextEdit edit = new MultiTextEdit();
                if (this.isNewlineNeeded(doc)) {
                    InputContext.insert((TextEdit)edit, (TextEdit)new InsertEdit(doc.getLength(), TextUtilities.getDefaultLineDelimiter((IDocument)doc)));
                }
                int i = 0;
                while (i < this.fEditOperations.size()) {
                    InputContext.insert((TextEdit)edit, this.fEditOperations.get(i));
                    ++i;
                }
                if (this.fModel instanceof IEditingModel) {
                    ((IEditingModel)this.fModel).setStale(true);
                }
                edit.apply(doc);
                this.fEditOperations.clear();
            }
            catch (MalformedTreeException e) {
                MTJLogger.log((int)4, (Throwable)e);
                flushed = false;
            }
            catch (BadLocationException e) {
                MTJLogger.log((int)4, (Throwable)e);
                flushed = false;
            }
        }
        if (flushed && this.fModel instanceof IEditable) {
            ((IEditable)this.fModel).setDirty(false);
        }
    }

    protected abstract String getDefaultCharset();

    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new IDocumentSetupParticipant(){

            public void setup(IDocument document) {
            }
        };
    }

    protected abstract String getPartitionName();

    protected boolean isNewlineNeeded(IDocument doc) throws BadLocationException {
        return PropertiesUtil.isNewlineNeeded((IDocument)doc);
    }

    protected boolean synchronizeModel(IDocument doc) {
        return true;
    }

    class ElementListener
    implements IElementStateListener {
        ElementListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (element != null && element.equals(InputContext.this.fEditorInput)) {
                InputContext.this.doRevert();
            }
        }

        public void elementDeleted(Object element) {
            if (element != null && element.equals(InputContext.this.fEditorInput)) {
                InputContext.this.dispose();
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (element != null && element.equals(InputContext.this.fEditorInput)) {
                InputContext.this.fMustSynchronize = true;
            }
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            if (originalElement != null && originalElement.equals(InputContext.this.fEditorInput)) {
                InputContext.this.dispose();
                InputContext.this.fEditor.close(true);
            }
        }
    }
}

