/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.views.markers.MarkerViewUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private ResourceBundle fBundle;
    private String fPrefix;
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public void run() {
        IMarker marker = this.chooseMarker(this.getMarkers());
        if (marker == null) {
            return;
        }
        IWorkbenchPage page = this.fTextEditor.getSite().getPage();
        MarkerViewUtil.showMarker((IWorkbenchPage)page, (IMarker)marker, (boolean)false);
        this.gotoMarker(marker);
    }

    public void update() {
        this.setEnabled(this.hasMarkers());
    }

    private void gotoMarker(IMarker marker) {
        int length;
        IEditorInput editorInput;
        IGotoMarker gotoMarkerAdapter = (IGotoMarker)this.fTextEditor.getAdapter(IGotoMarker.class);
        if (gotoMarkerAdapter != null) {
            gotoMarkerAdapter.gotoMarker(marker);
            return;
        }
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        int end = MarkerUtilities.getCharEnd((IMarker)marker);
        boolean selectLine = start < 0 || end < 0;
        IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)(editorInput = this.fTextEditor.getEditorInput()));
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                start = pos.getOffset();
                end = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return;
            }
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (selectLine) {
            try {
                int line;
                if (start >= 0) {
                    line = document.getLineOfOffset(start);
                } else {
                    line = MarkerUtilities.getLineNumber((IMarker)marker);
                    --line;
                }
                end = start + document.getLineLength(line) - 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        if (end - 1 < (length = document.getLength()) && start < length) {
            this.fTextEditor.selectAndReveal(start, end - start);
        }
    }

    private boolean includesLine(Position position, IDocument document, int line) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private void logException(IStatus status) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        log.log(status);
    }

    protected IMarker chooseMarker(List<IMarker> markers) {
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension access = this.getAnnotationAccessExtension();
        IMarker marker = null;
        int maxLayer = 0;
        for (IMarker m : markers) {
            MarkerAnnotation a = model.getMarkerAnnotation(m);
            if (a == null) continue;
            if (access == null) {
                marker = m;
                break;
            }
            int l = access.getLayer((Annotation)a);
            if (l == maxLayer) {
                if (marker != null) continue;
                marker = m;
                continue;
            }
            if (l <= maxLayer) continue;
            maxLayer = l;
            marker = m;
        }
        return marker;
    }

    protected IAnnotationAccessExtension getAnnotationAccessExtension() {
        Object adapter = this.fTextEditor.getAdapter(IAnnotationAccess.class);
        if (adapter instanceof IAnnotationAccessExtension) {
            return (IAnnotationAccessExtension)adapter;
        }
        return null;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected List<IMarker> getMarkers() {
        Iterator it;
        IMarker[] allMarkers;
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return Collections.emptyList();
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return Collections.emptyList();
        }
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return Collections.emptyList();
        }
        try {
            allMarkers = resource.findMarkers(null, true, 0);
        }
        catch (CoreException x) {
            this.handleCoreException(x, "SelectMarkerRulerAction.getMarker");
            return Collections.emptyList();
        }
        if (allMarkers.length == 0) {
            return Collections.emptyList();
        }
        int activeLine = this.fRuler.getLineOfLastMouseButtonActivity();
        if (activeLine == -1) {
            return Collections.emptyList();
        }
        try {
            IRegion line = document.getLineInformation(activeLine);
            it = model.getAnnotationIterator(line.getOffset(), line.getLength() + 1, true, true);
        }
        catch (BadLocationException e) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, "org.eclipse.ui", 0, e.getLocalizedMessage(), (Throwable)e));
            it = model.getAnnotationIterator();
        }
        ArrayList<IMarker> markers = null;
        while (it.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)it.next();
            if (!(annotation instanceof MarkerAnnotation) || !this.includesLine(position = model.getPosition(annotation), document, activeLine)) continue;
            if (markers == null) {
                markers = new ArrayList<IMarker>(10);
            }
            markers.add(((MarkerAnnotation)annotation).getMarker());
        }
        if (markers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(markers);
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected void handleCoreException(CoreException exception, String message) {
        Object status = message != null ? new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception) : exception.getStatus();
        this.logException((IStatus)status);
        Shell shell = this.fTextEditor.getSite().getShell();
        String title = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String msg = SelectMarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected boolean hasMarkers() {
        Iterator it;
        IMarker[] allMarkers;
        IResource resource = this.getResource();
        if (resource == null || !resource.exists()) {
            return false;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return false;
        }
        try {
            allMarkers = resource.findMarkers(null, true, 0);
        }
        catch (CoreException x) {
            this.handleCoreException(x, "SelectMarkerRulerAction.getMarker");
            return false;
        }
        if (allMarkers.length == 0) {
            return false;
        }
        int activeLine = this.fRuler.getLineOfLastMouseButtonActivity();
        if (activeLine == -1) {
            return false;
        }
        try {
            IRegion line = document.getLineInformation(activeLine);
            it = model.getAnnotationIterator(line.getOffset(), line.getLength() + 1, true, true);
        }
        catch (BadLocationException e) {
            this.logException((IStatus)new Status(4, "org.eclipse.ui", 0, e.getLocalizedMessage(), (Throwable)e));
            it = model.getAnnotationIterator();
        }
        while (it.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)it.next();
            if (!(annotation instanceof MarkerAnnotation) || !this.includesLine(position = model.getPosition(annotation), document, activeLine)) continue;
            return true;
        }
        return false;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

