/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.text.MTJWordFinder;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nXMLTextHover;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SourceInformationProvider
implements IInformationProvider,
IInformationProviderExtension2,
IPartListener {
    public static final int NO_IMP = 0;
    public static final int F_XML_IMP = 1;
    private IInformationControlCreator fPresenterControlCreator;
    protected String fCurrentPerspective;
    protected ITextHover fImplementation;
    protected int fImpType;
    protected MTJSourcePage fSourcePage;

    public SourceInformationProvider(MTJSourcePage editor, IInformationControlCreator creator, int impType) {
        this.fSourcePage = editor;
        this.fPresenterControlCreator = creator;
        this.fImpType = impType;
        if (this.fSourcePage != null && this.fImpType != 0) {
            this.fSourcePage.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
            this.update();
        }
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this.fImplementation != null && (s = this.fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return this.fPresenterControlCreator;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return MTJWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.update();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.update();
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.fSourcePage != null && part == this.fSourcePage.getEditor() && this.fImpType != 0) {
            this.fSourcePage.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchPage page = this.fSourcePage.getSite().getWorkbenchWindow().getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != perspectiveId) {
                this.fCurrentPerspective = perspectiveId;
                switch (this.fImpType) {
                    case 1: {
                        this.fImplementation = new L10nXMLTextHover(this.fSourcePage);
                    }
                }
            }
        }
    }
}

