/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.ui.editor.text.BaseMTJScanner;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.XMLWhitespaceDetector;

public class XMLTagScanner
extends BaseMTJScanner {
    private Token fStringToken;

    public XMLTagScanner(IColorManager manager) {
        super(manager);
    }

    public boolean affectsTextPresentation(String property) {
        return property.startsWith("editor.color.tag") || property.startsWith("editor.color.string");
    }

    protected Token getTokenAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.startsWith("editor.color.string")) {
            return this.fStringToken;
        }
        return (Token)this.fDefaultReturnToken;
    }

    protected void initialize() {
        this.fStringToken = new Token((Object)this.createTextAttribute("editor.color.string"));
        IRule[] rules = new IRule[]{new MultiLineRule("\"", "\"", (IToken)this.fStringToken), new SingleLineRule("'", "'", (IToken)this.fStringToken), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.tag")));
    }
}

