/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.ClasspathChangeMonitor;
import org.eclipse.mtj.internal.core.util.IClasspathChangeListener;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPropertiesPage
extends FormPage
implements MTJBuildPropertiesChangeListener,
IClasspathChangeListener {
    private static final String PAGE_TITLE = MTJUIMessages.BuildPropertiesPage_pageTitle;
    private static final String PAGE_ID = "buildPropertiesPage";
    private MTJBuildProperties properties;
    private IMTJProject mtjProject;
    private MTJRuntime currentRuntime;
    private ContainerCheckedTreeViewer resourcesViewer;
    private ComboViewer configurationsViewer;
    private boolean dirty;

    public BuildPropertiesPage(FormEditor editor, MTJBuildProperties buildProperties) {
        super(editor, PAGE_ID, PAGE_TITLE);
        this.properties = buildProperties;
        this.properties.addPropertiesChangeListener((MTJBuildPropertiesChangeListener)this);
        this.mtjProject = buildProperties.getMTJProject();
        ClasspathChangeMonitor.getInstance().addClasspathChangeListener(this.mtjProject, (IClasspathChangeListener)this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setText(this.getTitle());
        Composite body = form.getBody();
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 10;
        body.setLayout((Layout)layout);
        this.createConfigurationsSection(managedForm, body);
        this.createResourcesSection(managedForm, body);
        form.reflow(true);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.configurationsViewer.refresh();
            this.updateViewer();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.properties.store();
            this.setDirty(false);
            BuildStateMachine stateMachine = BuildStateMachine.getInstance((IMTJProject)this.mtjProject);
            if (stateMachine.getCurrentState() == null) {
                stateMachine.start(monitor);
            }
            this.mtjProject.getProject().build(6, "org.eclipse.mtj.core.packageBuilder", new HashMap(), monitor);
        }
        catch (IOException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void createConfigurationsSection(IManagedForm managedForm, Composite parent) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, false);
        Composite section = this.createSection(managedForm, parent, MTJUIMessages.BuildPropertiesPage_runtimeSectionTitle, MTJUIMessages.BuildPropertiesPage_runtimeSectionDetails, gridData);
        section.setLayout((Layout)new GridLayout(1, true));
        Combo combo = new Combo(section, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.setFocus();
        this.configurationsViewer = new ComboViewer(combo);
        this.configurationsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList result = new ArrayList();
                if (inputElement instanceof MTJRuntimeList) {
                    MTJRuntimeList runtimeList = (MTJRuntimeList)inputElement;
                    result.addAll(runtimeList);
                }
                return result.toArray();
            }

            public void dispose() {
            }
        });
        this.configurationsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                String text = null;
                if (element instanceof MTJRuntime) {
                    MTJRuntime runtime = (MTJRuntime)element;
                    text = runtime.getName();
                }
                return text;
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BuildPropertiesPage.this.updateViewer();
            }
        });
        MTJRuntimeList runtimeList = this.mtjProject.getRuntimeList();
        this.currentRuntime = runtimeList.getActiveMTJRuntime();
        this.configurationsViewer.setInput((Object)runtimeList);
        this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
    }

    private void updateViewer() {
        ISelection selection = this.configurationsViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            this.currentRuntime = this.mtjProject.getRuntimeList().getActiveMTJRuntime();
            this.configurationsViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentRuntime));
        } else {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.currentRuntime = (MTJRuntime)structuredSelection.getFirstElement();
        }
        this.updateCheckedElements();
    }

    private void updateCheckedElements() {
        this.resourcesViewer.setCheckedElements(new Object[0]);
        IResource[] includes = this.properties.getIncludes(this.currentRuntime);
        IResource[] excludes = this.properties.getExcludes(this.currentRuntime);
        IResource[] iResourceArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            IResource include = iResourceArray[n2];
            IPath includePath = include.getFullPath();
            ArrayList<IResource> myExcludes = new ArrayList<IResource>();
            IResource[] iResourceArray2 = excludes;
            int n3 = excludes.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource exclude = iResourceArray2[n4];
                IPath excludePath = exclude.getFullPath();
                if (includePath.isPrefixOf(excludePath)) {
                    myExcludes.add(exclude);
                }
                ++n4;
            }
            if (myExcludes.size() > 0) {
                this.selectNonExcludedResources(include, myExcludes);
            } else {
                this.resourcesViewer.setChecked((Object)include, true);
            }
            ++n2;
        }
    }

    private void selectNonExcludedResources(IResource include, List<IResource> excludes) {
        if (!(include instanceof IFolder)) {
            return;
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = ((IFolder)include).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IPath resourcePath = resource.getFullPath();
                boolean doInclude = true;
                boolean doSkip = false;
                for (IResource exclude : excludes) {
                    IPath excludePath = exclude.getFullPath();
                    if (resource.equals((Object)exclude)) {
                        doSkip = true;
                        break;
                    }
                    if (!resourcePath.isPrefixOf(excludePath)) continue;
                    doInclude = false;
                    break;
                }
                if (!doSkip) {
                    if (doInclude) {
                        this.resourcesViewer.setChecked((Object)resource, true);
                    } else {
                        this.selectNonExcludedResources(resource, excludes);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void createResourcesSection(IManagedForm managedForm, Composite parent) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        Composite section = this.createSection(managedForm, parent, MTJUIMessages.BuildPropertiesPage_resourcesSectionTitle, MTJUIMessages.BuildPropertiesPage_resourcesSectionDescription, gridData);
        section.setLayout((Layout)new GridLayout(1, true));
        Tree tree = new Tree(section, 2082);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.resourcesViewer = new ContainerCheckedTreeViewer(tree);
        this.resourcesViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.resourcesViewer.setInput((Object)this.mtjProject.getProject());
        this.resourcesViewer.setFilters(new ViewerFilter[]{new SourceFolderFilter(this.mtjProject.getJavaProject())});
        this.resourcesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    if (event.getChecked()) {
                        this.includeTopMostResource(resource);
                    } else {
                        this.excludeTopMostResource(resource);
                    }
                }
                BuildPropertiesPage.this.setDirty(true);
            }

            private void excludeTopMostResource(IResource resource) {
                ExcludesVisitor visitor = new ExcludesVisitor(BuildPropertiesPage.this.resourcesViewer, resource);
                try {
                    IResource[] sources;
                    IResource[] iResourceArray = sources = Utils.getSourceFolders((IJavaProject)BuildPropertiesPage.this.mtjProject.getJavaProject());
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource source = iResourceArray[n2];
                        IPath sourcePath = source.getFullPath();
                        if (sourcePath.isPrefixOf(resource.getFullPath())) {
                            source.accept((IResourceVisitor)visitor);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (Throwable)e);
                }
                BuildPropertiesPage.this.properties.excludeResource(visitor.getExclude(), BuildPropertiesPage.this.currentRuntime);
            }

            private void includeTopMostResource(IResource resource) {
                IncludesVisitor visitor = new IncludesVisitor(BuildPropertiesPage.this.resourcesViewer, resource);
                try {
                    IResource[] sources;
                    IResource[] iResourceArray = sources = Utils.getSourceFolders((IJavaProject)BuildPropertiesPage.this.mtjProject.getJavaProject());
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource source = iResourceArray[n2];
                        IPath sourcePath = source.getFullPath();
                        if (sourcePath.isPrefixOf(resource.getFullPath())) {
                            source.accept((IResourceVisitor)visitor);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (Throwable)e);
                }
                BuildPropertiesPage.this.properties.includeResource(visitor.getInclude(), BuildPropertiesPage.this.currentRuntime);
            }
        });
    }

    private Composite createSection(IManagedForm managedForm, Composite parent, String text, String description, GridData gridData) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        if (text != null) {
            section.setText(text);
        }
        if (description != null) {
            section.setDescription(description);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite client = toolkit.createComposite((Composite)section, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)client);
        return client;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    public void propertiesChanged(MTJBuildProperties buildProperties) {
        if (this.isActive() && this.currentRuntime != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BuildPropertiesPage.this.updateViewer();
                    BuildPropertiesPage.this.setDirty(false);
                }
            });
        }
    }

    public void classpathChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (BuildPropertiesPage.this.resourcesViewer != null) {
                    BuildPropertiesPage.this.resourcesViewer.refresh();
                    BuildPropertiesPage.this.updateViewer();
                    BuildPropertiesPage.this.setDirty(false);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        ClasspathChangeMonitor.getInstance().removeClasspathChangeListener(this.mtjProject, (IClasspathChangeListener)this);
    }

    class ExcludesVisitor
    implements IResourceVisitor {
        private ContainerCheckedTreeViewer resourcesViewer;
        private IResource resource;

        public ExcludesVisitor(ContainerCheckedTreeViewer _resourcesViewer, IResource _resource) {
            this.resourcesViewer = _resourcesViewer;
            this.resource = _resource;
        }

        public boolean visit(IResource _resource) throws CoreException {
            IPath myPath;
            boolean result = true;
            IPath resPath = _resource.getFullPath();
            if (resPath.equals((Object)(myPath = this.resource.getFullPath()))) {
                result = false;
            } else if (resPath.isPrefixOf(myPath)) {
                if (!this.resourcesViewer.getChecked((Object)_resource)) {
                    this.resource = _resource;
                    result = false;
                }
            } else {
                result = false;
            }
            return result;
        }

        public IResource getExclude() {
            return this.resource;
        }
    }

    class IncludesVisitor
    implements IResourceVisitor {
        private ContainerCheckedTreeViewer resourcesViewer;
        private IResource resource;

        public IncludesVisitor(ContainerCheckedTreeViewer _resourcesViewer, IResource _resource) {
            this.resourcesViewer = _resourcesViewer;
            this.resource = _resource;
        }

        public boolean visit(IResource _resource) throws CoreException {
            IPath myPath;
            boolean result = true;
            IPath resPath = _resource.getFullPath();
            if (resPath.equals((Object)(myPath = this.resource.getFullPath()))) {
                result = false;
            } else if (resPath.isPrefixOf(myPath)) {
                if (this.resourcesViewer.getChecked((Object)_resource) && !this.resourcesViewer.getGrayed((Object)_resource)) {
                    this.resource = _resource;
                    result = false;
                }
            } else {
                result = false;
            }
            return result;
        }

        public IResource getInclude() {
            return this.resource;
        }
    }

    private class SourceFolderFilter
    extends ViewerFilter {
        private IJavaProject javaProject;

        public SourceFolderFilter(IJavaProject _javaProject) {
            this.javaProject = _javaProject;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            if (element instanceof IResource) {
                IResource[] sources;
                IResource resource = (IResource)element;
                IPath path = resource.getFullPath();
                IResource[] iResourceArray = sources = Utils.getSourceFolders((IJavaProject)this.javaProject);
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource source = iResourceArray[n2];
                    IPath sourcePath = source.getFullPath();
                    if (sourcePath.isPrefixOf(path) || path.isPrefixOf(sourcePath)) {
                        result = true;
                    }
                    ++n2;
                }
            }
            return result;
        }
    }
}

