/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.build.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BuildPropertiesSourcePage
extends FormPage
implements MTJBuildPropertiesChangeListener {
    private MTJBuildProperties properties;
    private boolean dirty;
    private Text text;

    public BuildPropertiesSourcePage(FormEditor editor, MTJBuildProperties buildProperties) {
        super(editor, "buildPropertiesPageSource", "build.properties");
        this.properties = buildProperties;
        this.properties.addPropertiesChangeListener((MTJBuildPropertiesChangeListener)this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        Composite body = form.getBody();
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        body.setLayout((Layout)layout);
        this.createTextArea(managedForm, body);
        form.reflow(true);
    }

    private void createTextArea(IManagedForm managedForm, Composite body) {
        this.text = new Text(body, 770);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildPropertiesSourcePage.this.updateModel();
                BuildPropertiesSourcePage.this.setDirty(true);
            }
        });
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.updateViewer();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.setDirty(false);
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.getEditor().editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    private void updateModel() {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(this.text.getText().getBytes());
            this.properties.setContent((InputStream)stream);
        }
        catch (IOException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void updateViewer() {
        this.text.setText(this.properties.getContent().toString());
        this.setDirty(false);
    }

    public void propertiesChanged(MTJBuildProperties buildProperties) {
        if (this.isActive()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    BuildPropertiesSourcePage.this.updateViewer();
                }
            });
        }
    }
}

