/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.device.pages;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceBasicEditorPage
extends AbstractDeviceEditorPage {
    private static final Boolean[] BOOLEAN_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private ComboViewer debugServerCombo;
    private Text descriptionText;
    private Button executableBrowseButton;
    private Text executableText;
    private Text groupText;
    private boolean javaExecutableDevice;
    private Text launchCommandText;
    private Text nameText;
    private boolean preverifierEnabled;
    private Button preverifyBrowseButton;
    private Text preverifyExecutableText;

    public DeviceBasicEditorPage(Composite parent, boolean javaExecutableDevice, int style) {
        super(parent, style);
        this.javaExecutableDevice = javaExecutableDevice;
        this.preverifierEnabled = true;
    }

    public void commitDeviceChanges() throws CoreException {
        File exe;
        this.editDevice.setName(this.nameText.getText());
        this.editDevice.setGroupName(this.groupText.getText());
        this.editDevice.setDescription(this.descriptionText.getText());
        if (!this.javaExecutableDevice) {
            this.editDevice.setExecutable(new File(this.executableText.getText()));
        }
        this.editDevice.setDebugServer(this.getBooleanSelection(this.debugServerCombo));
        this.editDevice.setLaunchCommandTemplate(this.launchCommandText.getText());
        if (this.preverifierEnabled && (exe = new File(this.preverifyExecutableText.getText())).exists()) {
            IPreverifier standard = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)exe);
            this.editDevice.setPreverifier(standard);
        }
    }

    public String getDescription() {
        return MTJUIMessages.DeviceBasicEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceBasicEditorPage_title;
    }

    public void setDevice(IMIDPDevice device) {
        super.setDevice(device);
        this.initializeDeviceState();
    }

    private ComboViewer createBooleanComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.setContentProvider((IContentProvider)new BooleanContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new BooleanLabelProvider());
        viewer.setInput(new Object());
        return viewer;
    }

    private boolean getBooleanSelection(ComboViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        Boolean value = (Boolean)selection.getFirstElement();
        return value;
    }

    private void initializeDeviceState() {
        if (this.nameText != null && this.editDevice != null) {
            this.nameText.setText(this.editDevice.getName());
            this.groupText.setText(this.editDevice.getSDKName());
            this.descriptionText.setText(this.editDevice.getDescription());
            String exeText = this.javaExecutableDevice ? "Java" : this.editDevice.getExecutable().toString();
            this.executableText.setText(exeText);
            this.executableText.setEnabled(!this.javaExecutableDevice);
            this.executableBrowseButton.setEnabled(!this.javaExecutableDevice);
            this.setBooleanSelection(this.debugServerCombo, this.editDevice.isDebugServer());
            this.launchCommandText.setText(this.editDevice.getLaunchCommandTemplate());
            this.preverifierEnabled = true;
            IPreverifier preverifier = this.editDevice.getPreverifier();
            this.preverifierEnabled = true;
            this.preverifyExecutableText.setText(preverifier != null ? preverifier.getPreverifierExecutable().toString() : "");
            this.preverifyBrowseButton.setEnabled(this.preverifierEnabled);
            this.preverifyExecutableText.setEnabled(this.preverifierEnabled);
        }
    }

    private void setBooleanSelection(ComboViewer viewer, boolean value) {
        StructuredSelection selection = new StructuredSelection((Object)value);
        viewer.setSelection((ISelection)selection, true);
    }

    private void updateState() {
        String errorMessage = null;
        if (this.nameText.getText().length() == 0) {
            errorMessage = MTJUIMessages.DeviceBasicEditorPage_error_no_device_name;
        } else if (this.groupText.getText().length() == 0) {
            errorMessage = MTJUIMessages.DeviceBasicEditorPage_error_no_device_group;
        } else if (this.launchCommandText.getText().length() == 0) {
            errorMessage = MTJUIMessages.DeviceBasicEditorPage_error_no_launch_command;
        } else {
            File executable = new File(this.executableText.getText());
            if (!this.javaExecutableDevice && !executable.exists()) {
                errorMessage = MTJUIMessages.DeviceBasicEditorPage_error_invalid_executable;
            } else {
                executable = new File(this.preverifyExecutableText.getText());
                if (!executable.exists() && !(executable = new File(String.valueOf(this.preverifyExecutableText.getText()) + ".exe")).exists()) {
                    errorMessage = MTJUIMessages.DeviceBasicEditorPage_error_invalid_preverifier;
                }
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    protected void addPageControls(Composite parent) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceBasicEditorPage.this.updateState();
            }
        };
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(3, false));
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_name_label);
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(modifyListener);
        this.nameText.setEditable(false);
        new Label(parent, 0);
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_group_label);
        this.groupText = new Text(parent, 2048);
        this.groupText.setLayoutData((Object)new GridData(768));
        this.groupText.addModifyListener(modifyListener);
        this.groupText.setEditable(false);
        new Label(parent, 0);
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_description_label);
        this.descriptionText = new Text(parent, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_executable_label);
        this.executableText = new Text(parent, 2048);
        this.executableText.setLayoutData((Object)new GridData(768));
        this.executableText.addModifyListener(modifyListener);
        this.executableBrowseButton = new Button(parent, 8);
        this.executableBrowseButton.setText(MTJUIMessages.DeviceBasicEditorPage_executableBrowseButton_label);
        this.executableBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.executableText);
            }
        });
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_preverifier_label);
        this.preverifyExecutableText = new Text(parent, 2048);
        this.preverifyExecutableText.setLayoutData((Object)new GridData(768));
        this.preverifyExecutableText.addModifyListener(modifyListener);
        this.preverifyBrowseButton = new Button(parent, 8);
        this.preverifyBrowseButton.setText(MTJUIMessages.DeviceBasicEditorPage_preverifyBrowseButton_label);
        this.preverifyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.preverifyExecutableText);
            }
        });
        new Label(parent, 0);
        Label preverifierTip = new Label(parent, 64);
        preverifierTip.setText(MTJUIMessages.DeviceBasicEditorPage_preverifierTip);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        preverifierTip.setLayoutData((Object)gd);
        Label blankLabel1 = new Label(parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        blankLabel1.setLayoutData((Object)gd);
        new Label(parent, 0).setText(MTJUIMessages.DeviceBasicEditorPage_debug_server_label);
        this.debugServerCombo = this.createBooleanComboViewer(parent);
        this.debugServerCombo.getCombo().setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
        Label blankLabel2 = new Label(parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        blankLabel2.setLayoutData((Object)gd);
        Label launchCommandLabel = new Label(parent, 0);
        launchCommandLabel.setText(MTJUIMessages.DeviceBasicEditorPage_launchCommand_label);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        launchCommandLabel.setLayoutData((Object)gd);
        this.launchCommandText = new Text(parent, 2114);
        this.launchCommandText.setTextLimit(1000);
        this.launchCommandText.addModifyListener(modifyListener);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 500;
        gd.heightHint = 300;
        this.launchCommandText.setLayoutData((Object)gd);
        this.initializeDeviceState();
    }

    protected void browseForExecutable(Text textField) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(MTJUIMessages.DeviceBasicEditorPage_browseForExecutable_dialog_title);
        File currentFile = new File(textField.getText());
        while (currentFile != null) {
            if (currentFile.exists()) {
                dialog.setFileName(currentFile.toString());
                break;
            }
            currentFile = currentFile.getParentFile();
        }
        String filename = dialog.open();
        if (filename != null) {
            textField.setText(filename);
        }
    }

    private static class BooleanContentProvider
    implements IStructuredContentProvider {
        private BooleanContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return BOOLEAN_VALUES;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class BooleanLabelProvider
    extends LabelProvider {
        private BooleanLabelProvider() {
        }

        public String getText(Object element) {
            Boolean bool = (Boolean)element;
            return bool != false ? MTJUIMessages.DeviceBasicEditorPage_yes_label : MTJUIMessages.DeviceBasicEditorPage_no_label;
        }
    }
}

