/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.device.pages;

import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.viewers.TableColumnInfo;
import org.eclipse.mtj.internal.ui.viewers.TableViewerConfiguration;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DeviceSymbolSetEditorPage
extends AbstractDeviceEditorPage {
    private static final String DEVICE_SYMBOLSET_VIEWER_SETTINGS = "deviceSymbolsetViewerSettings";
    private static final TableColumnInfo[] COLUMN_INFO = new TableColumnInfo[]{new TableColumnInfo(MTJUIMessages.DeviceSymbolsetEditorPage_symbol_columnInfo, 40.0f, null), new TableColumnInfo(MTJUIMessages.DeviceSymbolsetEditorPage_value_columnInfo, 60.0f, null)};
    private static final int DEFAULT_TABLE_WIDTH = 650;
    private static final Object[] NO_ELEMENTS = new Object[0];
    private TableViewer viewer;

    public DeviceSymbolSetEditorPage(Composite parent, int style) {
        super(parent, style);
    }

    public void commitDeviceChanges() {
    }

    public String getDescription() {
        return MTJUIMessages.DeviceSymbolsetEditorPage_description;
    }

    public String getTitle() {
        return MTJUIMessages.DeviceSymbolsetEditorPage_title;
    }

    public void setDevice(IMIDPDevice device) {
        super.setDevice(device);
        this.viewer.setInput((Object)device);
    }

    private TableViewer createTableViewer(Composite composite) {
        int styles = 68100;
        Table table = new Table(composite, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new DevicePropertiesContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)MTJUIPlugin.getDefault().getLabelProvider());
        IDialogSettings viewerSettings = MTJUIPlugin.getDialogSettings(DEVICE_SYMBOLSET_VIEWER_SETTINGS);
        TableViewerConfiguration viewerConfiguration = new TableViewerConfiguration(viewerSettings, 650, COLUMN_INFO, 0);
        viewerConfiguration.configure(viewer);
        return viewer;
    }

    protected void addPageControls(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.minimumWidth = 650;
        gridData.heightHint = 400;
        this.viewer = this.createTableViewer(parent);
        this.viewer.getTable().setLayoutData((Object)gridData);
    }

    private static class DevicePropertiesContentProvider
    implements IStructuredContentProvider {
        private DevicePropertiesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            IDevice device;
            ISymbolSet deviceProperties;
            Object[] elements = NO_ELEMENTS;
            if (inputElement instanceof IMIDPDevice && (deviceProperties = (device = (IDevice)inputElement).getSymbolSet()) != null) {
                Collection collection = deviceProperties.getSymbols();
                elements = collection.toArray();
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

