/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.forms.blocks.NamedObject;

public class MidletType
extends NamedObject {
    private static final String P_CLASSNAME = "className";
    private static final String P_ICON = "icon";
    private static final String P_MIDLETNAME = "midletName";
    private String midletName;
    private String icon;
    private String className;

    MidletType(String id, String definitionString) {
        super(id);
        String[] fields = new String[3];
        String[] tokens = this.tokenize(definitionString, ',');
        try {
            int i = 0;
            while (i < 3) {
                fields[i] = i > tokens.length ? "" : tokens[i];
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        this.midletName = fields[0];
        this.icon = fields[1];
        this.className = fields[2];
    }

    MidletType(String id, String name, String icon, String className) {
        super(id);
        this.midletName = name;
        this.icon = icon;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getMidletName() {
        return this.midletName;
    }

    public void setClassName(String className) {
        this.className = className;
        this.model.fireModelChanged(new Object[]{this}, "__changed", P_CLASSNAME);
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.model.fireModelChanged(new Object[]{this}, "__changed", P_ICON);
    }

    public void setMidletName(String name) {
        this.midletName = name;
        this.model.fireModelChanged(new Object[]{this}, "__changed", P_MIDLETNAME);
    }

    private String[] tokenize(String string, char delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        int offset = 0;
        int delimiterIndex = 0;
        do {
            if ((delimiterIndex = string.indexOf(delimiter, offset)) == -1) {
                tokens.add(string.substring(offset));
                continue;
            }
            tokens.add(string.substring(offset, delimiterIndex));
            offset = delimiterIndex + 1;
        } while (delimiterIndex != -1);
        return tokens.toArray(new String[tokens.size()]);
    }

    public String toString() {
        return String.valueOf(this.midletName) + "," + this.icon + "," + this.className;
    }
}

