/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.source.rules;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IJADDescriptorsProvider;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.swt.graphics.RGB;

public class JadScanner
extends RuleBasedScanner {
    private static final String KEYWORD_COLOR = "mtj.jad.keyword.color";
    private static final String VALUE_COLOR = "mtj.jad.value.color";
    private static final ColorRegistry colorRegistry = new ColorRegistry();

    static {
        colorRegistry.put(KEYWORD_COLOR, new RGB(127, 0, 85));
        colorRegistry.put(VALUE_COLOR, new RGB(0, 0, 0));
    }

    public JadScanner() {
        IWordDetector detector = new IWordDetector(){

            public boolean isWordPart(char c) {
                if (c == ':') {
                    return false;
                }
                if (c == '-') {
                    return true;
                }
                return Character.isJavaIdentifierPart(c);
            }

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
        };
        Token keyword = new Token((Object)new TextAttribute(colorRegistry.get(KEYWORD_COLOR), null, 1));
        Token key = new Token((Object)new TextAttribute(colorRegistry.get(KEYWORD_COLOR), null, 0));
        WordRule rule = new WordRule(detector, (IToken)key);
        IJADDescriptorsProvider[] providers = JADAttributesRegistry.getAllJADDescriptorProviders();
        int i = 0;
        while (i < providers.length) {
            DescriptorPropertyDescription[] descriptions = providers[i].getDescriptorPropertyDescriptions();
            int j = 0;
            while (j < descriptions.length) {
                rule.addWord(descriptions[j].getPropertyName(), (IToken)keyword);
                ++j;
            }
            ++i;
        }
        Token string = new Token((Object)new TextAttribute(colorRegistry.get(VALUE_COLOR)));
        SingleLineRule singleLineRule = new SingleLineRule(":", null, (IToken)string, '\\');
        WhitespaceRule whiteSpaceRule = new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        });
        this.setRules(new IRule[]{rule, singleLineRule, whiteSpaceRule});
    }
}

