/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.source.rules;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class Scanner
extends RuleBasedScanner {
    public static final Color KEYWORD = new Color((Device)Display.getCurrent(), 127, 0, 85);
    public static final Color STRING = new Color((Device)Display.getCurrent(), 0, 0, 0);

    public Scanner() {
        IWordDetector detector = new IWordDetector(){

            public boolean isWordPart(char c) {
                if (c == '-') {
                    return true;
                }
                return Character.isJavaIdentifierPart(c);
            }

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
        };
        WordRule rule = new WordRule(detector);
        Token keyword = new Token((Object)new TextAttribute(KEYWORD, null, 1));
        Token string = new Token((Object)new TextAttribute(STRING));
        rule.addWord("MIDlet-Jar-Size", (IToken)keyword);
        rule.addWord("MIDlet-Jar-URL", (IToken)keyword);
        rule.addWord("MIDlet-Name", (IToken)keyword);
        rule.addWord("MIDlet-Vendor", (IToken)keyword);
        rule.addWord("MIDlet-Version", (IToken)keyword);
        rule.addWord("MicroEdition-Configuration", (IToken)keyword);
        rule.addWord("MicroEdition-Profile", (IToken)keyword);
        rule.addWord("MIDlet-Data-Size", (IToken)keyword);
        rule.addWord("MIDlet-Delete-Confirm", (IToken)keyword);
        rule.addWord("MIDlet-Delete-Notify", (IToken)keyword);
        rule.addWord("MIDlet-Description", (IToken)keyword);
        rule.addWord("MIDlet-Icon", (IToken)keyword);
        rule.addWord("MIDlet-Info-URL", (IToken)keyword);
        rule.addWord("MIDlet-Install-Notify", (IToken)keyword);
        rule.addWord("MIDlet-Permissions", (IToken)keyword);
        rule.addWord("MIDlet-Permissions-Opt", (IToken)keyword);
        rule.addWord("MIDlet-Jar-RSA-SHA1", (IToken)keyword);
        this.setRules(new IRule[]{rule, new SingleLineRule("\"", "\"", (IToken)string, '\\'), new SingleLineRule("'", "'", (IToken)string, '\\'), new SingleLineRule(" ", null, (IToken)string, '\\'), new WordPatternRule(detector, "MIDlet-", null, (IToken)keyword), new WordPatternRule(detector, "MIDlet-Certificate-1-", null, (IToken)keyword), new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        })});
    }
}

