/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.text.AbstractEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerManager;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "l10n-context";
    private L10nMarkerManager markerManager = new L10nMarkerManager();

    public L10nInputContext(MTJFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
        this.updateMarkersFromModel((IFileEditorInput)super.getInput(), (L10nModel)this.getModel());
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        L10nModel fModel = (L10nModel)this.getModel();
        fModel.getLocales().validate();
        if (this.validateModel(fModel)) {
            return;
        }
        this.validateDefaultLocale(fModel);
    }

    private void validateDefaultLocale(L10nModel fModel) {
        int line = -1;
        String warningMessage = MTJUIMessages.L10nLocaleDetails_noDefaultLocale;
        if (fModel.getLocales().getDefaultLocale() == null) {
            line = fModel.getLocales().getLocalesLine() + 1;
            this.addWarningMarker((IFileEditorInput)super.getInput(), line, warningMessage);
        } else {
            this.cleanMarkers((IFileEditorInput)super.getInput(), 1);
        }
    }

    public boolean validateModel(L10nModel model) {
        Vector markerErrors = model.getLocales().getMarkerErrors();
        this.cleanMarkers((IFileEditorInput)super.getInput(), 2);
        if (markerErrors.size() > 0) {
            int i = 0;
            while (i < markerErrors.size()) {
                this.updateMarkersFromLines((IFileEditorInput)super.getInput(), ((L10nMarkerError)markerErrors.get(i)).getLine(), ((L10nMarkerError)markerErrors.get(i)).getErrorMessage());
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            L10nModel model = new L10nModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(file.getCharset());
            } else if (input instanceof SystemFileEditorInput) {
                File file = (File)((SystemFileEditorInput)input).getAdapter(File.class);
                model.setInstallLocation(file.getParent());
                model.setCharset(this.getDefaultCharset());
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
            return model;
        }
        return null;
    }

    @Override
    protected String getDefaultCharset() {
        return "ISO-8859-1";
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected String getPartitionName() {
        return "___l10n_partition";
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    private void updateMarkersFromModel(IFileEditorInput editor, L10nModel model) {
        try {
            this.markerManager.createMarker(editor.getFile(), model);
        }
        catch (CoreException coreException) {}
    }

    private void updateMarkersFromLines(IFileEditorInput editor, int line, String errorMessage) {
        try {
            this.markerManager.createMarker(editor.getFile(), line, errorMessage, false);
        }
        catch (CoreException coreException) {}
    }

    private void cleanMarkers(IFileEditorInput editor, int severity) {
        try {
            this.markerManager.clearMarkers(editor.getFile(), severity);
        }
        catch (CoreException coreException) {}
    }

    private void addWarningMarker(IFileEditorInput editor, int line, String warningMessage) {
        try {
            this.markerManager.addWarningMarker(editor.getFile(), line, warningMessage);
        }
        catch (CoreException coreException) {}
    }
}

