/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.MultiSourceEditor;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.context.InputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nFormOutlinePage;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nInputContext;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nInputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nUtil;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nEntriesTablePage;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nSourcePage;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.LocalizationPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public class LocalizationDataEditor
extends MultiSourceEditor {
    public boolean canCut(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object obj : sel) {
                if (!(obj instanceof L10nObject) || !((L10nObject)obj).canBeRemoved()) continue;
                return this.canCopy(selection);
            }
        }
        return false;
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        try {
            L10nModel model = (L10nModel)this.inputContextManager.findContext("l10n-context").getModel();
            model.validate();
            L10nApi.syncronizeApi((L10nModel)model);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        catch (Throwable t) {
            MTJLogger.log((int)4, (Throwable)t);
        }
    }

    public void editorContextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public ISelection getSelection() {
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof LocalizationPage) {
            return ((LocalizationPage)formPage).getSelection();
        }
        return super.getSelection();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public void updateMessageManager(L10nLocales locales) {
        IMessageManager manager = this.getActivePageInstance().getManagedForm().getMessageManager();
        manager.removeAllMessages();
        this.displayDefaultLocaleWarning(manager, locales);
        this.displayLocaleKeysConflict(manager, locales);
        this.displayLocaleNameError(manager, locales);
    }

    private void displayLocaleKeysConflict(IMessageManager manager, L10nLocales locales) {
        List<L10nLocale> conflicted = L10nUtil.findConflictedLocales(locales);
        for (L10nLocale locale : conflicted) {
            String message = NLS.bind((String)MTJUIMessages.LocalizationDataEditor_localeDuplicatedKeys, (Object)locale.getName());
            manager.addMessage((Object)locale, message, null, 3);
        }
    }

    private void displayLocaleNameError(IMessageManager manager, L10nLocales locales) {
        IDocumentElementNode[] localeNodes;
        IDocumentElementNode[] iDocumentElementNodeArray = localeNodes = locales.getChildNodes();
        int n = localeNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode localeNode = iDocumentElementNodeArray[n2];
            L10nLocale locale = (L10nLocale)localeNode;
            if (locale.getStatus().getSeverity() == 4) {
                manager.addMessage((Object)locale, locale.getStatus().getMessage(), null, 3);
            }
            ++n2;
        }
    }

    private void displayDefaultLocaleWarning(IMessageManager manager, L10nLocales locales) {
        if (locales.getDefaultLocale() == null) {
            manager.addMessage((Object)this, MTJUIMessages.L10nLocaleDetails_noDefaultLocale, null, 2);
        }
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new LocalizationPage(this));
            this.addPage((IFormPage)new L10nEntriesTablePage(this));
        }
        catch (PartInitException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        this.addSourcePage("l10n-context");
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new L10nFormOutlinePage(this);
    }

    protected InputContextManager createInputContextManager() {
        return new L10nInputContextManager(this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, new L10nInputContext(this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected MTJSourcePage createSourcePage(MTJFormEditor editor, String title, String name, String contextId) {
        return new L10nSourcePage(editor, title, name);
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, new L10nInputContext(this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, SystemFileEditorInput input) {
        File file = (File)input.getAdapter(File.class);
        if (file != null) {
            SystemFileEditorInput in = new SystemFileEditorInput(file);
            contexts.putContext((IEditorInput)in, new L10nInputContext(this, (IEditorInput)in, true));
        }
    }

    protected String getEditorID() {
        return "org.eclipse.mtj.ui.editor.LocalizationDataEditor";
    }

    protected InputContext getInputContext(Object object) {
        return this.inputContextManager.findContext("l10n-context");
    }

    protected void pageChange(int newPageIndex) {
        L10nModel model;
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        if (page instanceof LocalizationPage && (model = (L10nModel)this.inputContextManager.findContext("l10n-context").getModel()) != null) {
            this.updateMessageManager(model.getLocales());
        }
    }
}

