/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;

public class L10nRemoveObjectAction
extends Action {
    private L10nObject[] l10nObjects;
    private L10nObject objectToSelect;

    public L10nRemoveObjectAction() {
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setText(MTJUIMessages.L10nRemoveObjectAction_text);
        this.l10nObjects = null;
        this.objectToSelect = null;
    }

    public L10nObject getNextSelection() {
        return this.objectToSelect;
    }

    public void run() {
        if (this.l10nObjects == null) {
            return;
        }
        int i = 0;
        while (i < this.l10nObjects.length) {
            L10nObject parent;
            if (this.l10nObjects[i] != null && this.l10nObjects[i].canBeRemoved() && (parent = this.l10nObjects[i].getParent()) != null && parent.canBeParent()) {
                this.determineNextSelection(parent, i);
                parent.removeChildNode((IDocumentElementNode)this.l10nObjects[i], true);
            }
            ++i;
        }
    }

    public void setToRemove(L10nObject tocObject) {
        this.l10nObjects = new L10nObject[]{tocObject};
    }

    public void setToRemove(L10nObject[] tocObjects) {
        this.l10nObjects = tocObjects;
    }

    private void determineNextSelection(L10nObject parent, int index) {
        this.objectToSelect = parent.getNextSibling(this.l10nObjects[index]);
        if (this.objectToSelect == null) {
            this.objectToSelect = parent.getPreviousSibling(this.l10nObjects[index]);
            if (this.objectToSelect == null) {
                this.objectToSelect = parent;
            }
        }
    }
}

