/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.ui.editor.MTJDetails;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editors.FormLayoutFactory;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class L10nAbstractDetails
extends MTJDetails {
    private static final int NUM_COLUMNS = 3;
    private String fContextID;
    private Section fMainSection;
    private LocalesTreeSection fMasterSection;

    public L10nAbstractDetails(LocalesTreeSection masterSection, String contextID) {
        this.fMasterSection = masterSection;
        this.fContextID = contextID;
        this.fMainSection = null;
    }

    public void createContents(Composite parent) {
        this.configureParentLayout(parent);
        this.createDetails(parent);
        this.hookListeners();
    }

    public void createDetails(Composite parent) {
        int style = 256;
        if (this.getDetailsDescription() != null) {
            style |= 0x80;
        }
        this.fMainSection = this.getPage().createUISection(parent, this.getDetailsTitle(), this.getDetailsDescription(), style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fMainSection, 3);
        GridData data = new GridData(1808);
        this.fMainSection.setLayoutData((Object)data);
        this.createFields(sectionClient);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fMainSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fMainSection);
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getMTJEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public String getContextId() {
        return this.fContextID;
    }

    public LocalesTreeSection getMasterSection() {
        return this.fMasterSection;
    }

    public MTJFormPage getPage() {
        return (MTJFormPage)((Object)this.getManagedForm().getContainer());
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public abstract void hookListeners();

    public boolean isEditable() {
        return this.fMasterSection.isEditable();
    }

    public boolean isEditableElement() {
        return this.fMasterSection.isEditable();
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
    }

    public abstract void updateFields();

    private void configureParentLayout(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
    }

    protected abstract void createFields(Composite var1);

    protected void createLabel(Composite client, FormToolkit toolkit, String text) {
        Label label = toolkit.createLabel(client, text, 64);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    protected void createSpace(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), "");
    }

    protected abstract String getDetailsDescription();

    protected abstract String getDetailsTitle();

    protected Object getFirstSelectedObject(ISelection selection) {
        IStructuredSelection structuredSel = (IStructuredSelection)selection;
        if (structuredSel == null) {
            return null;
        }
        return structuredSel.getFirstElement();
    }
}

