/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalizationDataEditor;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;

public class L10nLocaleDetails
extends L10nAbstractDetails {
    private L10nLocale locale = null;
    private FormEntry localeCountryCodeEntry = null;
    private FormEntry localeLanguageCodeEntry = null;
    private Button defaultBtn;

    public L10nLocaleDetails(LocalesTreeSection masterSection) {
        super(masterSection, "l10n-context");
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.localeCountryCodeEntry.commit();
        this.localeLanguageCodeEntry.commit();
    }

    public void createFields(Composite parent) {
        this.createLanguageCodeWidget(parent);
        this.createSpace(parent);
        this.createCountryCodeWidget(parent);
        this.createDefaultLocaleWidget(parent);
    }

    public void hookListeners() {
        this.createLocaleCountryCodeEntryListeners();
        this.createLocaleLanguageCodeEntryListeners();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof L10nLocale) {
            this.setData((L10nLocale)object);
            this.updateFields();
        }
    }

    public void setData(L10nLocale object) {
        this.locale = object;
    }

    public void updateFields() {
        if (this.locale != null) {
            FormEditor editor;
            this.updateLocaleCountryCodeEntry(this.isEditableElement());
            this.updateLocaleLanguageCodeEntry(this.isEditableElement());
            L10nLocales locales = this.locale.getLocales();
            if (locales == null) {
                return;
            }
            L10nLocale defaultLocale = locales.getDefaultLocale();
            if (defaultLocale != null) {
                boolean enabled = defaultLocale.equals(this.locale);
                this.defaultBtn.setSelection(enabled);
            }
            if ((editor = this.getPage().getEditor()) instanceof LocalizationDataEditor) {
                ((LocalizationDataEditor)editor).updateMessageManager(locales);
            }
        }
    }

    private void createCountryCodeWidget(Composite parent) {
        this.localeCountryCodeEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocaleDetails_countrycode_label, MTJUIMessages.L10nLocaleDetails_choose_btn_label, false);
        this.localeCountryCodeEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createLanguageCodeWidget(Composite parent) {
        this.localeLanguageCodeEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocaleDetails_languagecode_label, MTJUIMessages.L10nLocaleDetails_choose_btn_label, false);
        this.localeLanguageCodeEntry.getText().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createLocaleCountryCodeEntryListeners() {
        this.localeCountryCodeEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                L10nLocaleDetails.this.handleContryCodeEntryBrowse();
            }

            public void textValueChanged(FormEntry entry) {
                if (L10nLocaleDetails.this.locale != null) {
                    L10nLocaleDetails.this.locale.setCountryCode(L10nLocaleDetails.this.localeCountryCodeEntry.getValue());
                    L10nLocaleDetails.this.locale.getLocales().validate();
                    FormEditor editor = L10nLocaleDetails.this.getPage().getEditor();
                    if (editor instanceof LocalizationDataEditor) {
                        ((LocalizationDataEditor)editor).updateMessageManager(L10nLocaleDetails.this.locale.getLocales());
                    }
                }
            }
        });
    }

    private void createLocaleLanguageCodeEntryListeners() {
        this.localeLanguageCodeEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                L10nLocaleDetails.this.handleLanguageCodeEntryBrowse();
            }

            public void textValueChanged(FormEntry entry) {
                if (L10nLocaleDetails.this.locale != null) {
                    L10nLocaleDetails.this.locale.setLanguageCode(L10nLocaleDetails.this.localeLanguageCodeEntry.getValue());
                    L10nLocaleDetails.this.locale.getLocales().validate();
                    FormEditor editor = L10nLocaleDetails.this.getPage().getEditor();
                    if (editor instanceof LocalizationDataEditor) {
                        ((LocalizationDataEditor)editor).updateMessageManager(L10nLocaleDetails.this.locale.getLocales());
                    }
                }
            }
        });
    }

    private void createDefaultLocaleWidget(Composite parent) {
        this.defaultBtn = new Button(parent, 32);
        this.defaultBtn.setText(MTJUIMessages.L10nLocaleDetails_defaultLocale);
        this.defaultBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                L10nLocales locales = L10nLocaleDetails.this.locale.getLocales();
                if (locales != null) {
                    IMessageManager messageManager = L10nLocaleDetails.this.getManagedForm().getMessageManager();
                    messageManager.removeAllMessages();
                    if (L10nLocaleDetails.this.defaultBtn.getSelection()) {
                        locales.setDefaultLocale(L10nLocaleDetails.this.locale);
                    } else {
                        locales.setDefaultLocale(null);
                        messageManager.addMessage((Object)L10nLocaleDetails.this.defaultBtn, MTJUIMessages.L10nLocaleDetails_noDefaultLocale, null, 2);
                    }
                }
            }
        });
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        this.defaultBtn.setLayoutData((Object)gridData);
    }

    private void handleContryCodeEntryBrowse() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationCountryBrowseDialog_title);
        dialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationCountryBrowseDialog_message);
        dialog.setElements((Object[])Locale.getISOCountries());
        if (dialog.open() == 0) {
            String folder = (String)dialog.getFirstResult();
            this.localeCountryCodeEntry.setValue(folder);
        }
    }

    private void handleLanguageCodeEntryBrowse() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new LabelProvider());
        dialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationLanguageBrowseDialog_title);
        dialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationLanguageBrowseDialog_message);
        dialog.setElements((Object[])Locale.getISOLanguages());
        if (dialog.open() == 0) {
            String folder = (String)dialog.getFirstResult();
            this.localeLanguageCodeEntry.setValue(folder);
        }
    }

    private void updateLocaleCountryCodeEntry(boolean editable) {
        this.localeCountryCodeEntry.setValue(this.locale.getCountryCode(), true);
        this.localeCountryCodeEntry.setEditable(editable);
    }

    private void updateLocaleLanguageCodeEntry(boolean editable) {
        this.localeLanguageCodeEntry.setValue(this.locale.getLanguageCode(), true);
        this.localeLanguageCodeEntry.setEditable(editable);
    }

    protected L10nObject getDataObject() {
        return this.locale;
    }

    protected String getDetailsDescription() {
        return MTJUIMessages.L10nLocaleDetails_detailsDescription;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nLocaleDetails_detailsTitle;
    }
}

