/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.details;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SrcFolderFilter;
import org.eclipse.mtj.internal.ui.editor.FormEntryAdapter;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesTreeSection;
import org.eclipse.mtj.internal.ui.editors.l10n.details.L10nAbstractDetails;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.mtj.internal.ui.util.FolderValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class L10nLocalesDetails
extends L10nAbstractDetails {
    private L10nLocales locales = null;
    private FormEntry locationEntry = null;
    private FormEntry packageEntry = null;

    public L10nLocalesDetails(LocalesTreeSection masterSection) {
        super(masterSection, "l10n-context");
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.packageEntry.commit();
        this.locationEntry.commit();
    }

    public void createFields(Composite parent) {
        this.createPackageWidget(parent);
        this.createSpace(parent);
        this.createLocationWidget(parent);
    }

    public void hookListeners() {
        this.createPackageEntryListeners();
        this.createLocationEntryListeners();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object != null && object instanceof L10nLocales) {
            this.setData((L10nLocales)object);
            this.updateFields();
        }
    }

    public void setData(L10nLocales object) {
        this.locales = object;
    }

    public void updateFields() {
        if (this.locales != null) {
            this.updatePackageEntry(this.isEditableElement());
            this.updateDestinationEntry(this.isEditableElement());
        }
    }

    private void createLocationEntryListeners() {
        this.locationEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                L10nLocalesDetails.this.handleLocationEntryBrowse();
            }

            public void textValueChanged(FormEntry entry) {
                if (L10nLocalesDetails.this.locales != null) {
                    L10nLocalesDetails.this.locales.setDestination(L10nLocalesDetails.this.locationEntry.getValue());
                }
            }
        });
    }

    private void createLocationWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_locationWidget_label);
        this.locationEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_locationEntry_label, MTJUIMessages.L10nLocalesDetails_browse_label, false);
    }

    private void createPackageEntryListeners() {
        this.packageEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                L10nLocalesDetails.this.handlePackageEntryBrowse();
            }

            public void textValueChanged(FormEntry entry) {
                if (L10nLocalesDetails.this.locales != null) {
                    L10nLocalesDetails.this.locales.setPackage(L10nLocalesDetails.this.packageEntry.getValue());
                }
            }
        });
    }

    private void handlePackageEntryBrowse() {
        try {
            Object[] result;
            IResource file = this.locales.getModel().getUnderlyingResource();
            IJavaProject project = JavaCore.create((IProject)file.getProject());
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this.getPage().getSite().getShell(), (IJavaProject)project, (int)0);
            dialog.setMessage(MTJUIMessages.L10nLocalesDetails_packageEntryBrowseDialog_message);
            dialog.setTitle(MTJUIMessages.L10nLocalesDetails_packageEntryBrowseDialog_title);
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && this.locales != null) {
                this.packageEntry.setValue(((IPackageFragment)dialog.getResult()[0]).getElementName());
            }
        }
        catch (JavaModelException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    private void createPackageWidget(Composite parent) {
        this.createLabel(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_packageWidget_label);
        this.packageEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), MTJUIMessages.L10nLocalesDetails_packageEntry_label, MTJUIMessages.L10nLocalesDetails_browse_label, false);
    }

    private void handleLocationEntryBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getPage().getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IResource file = this.locales.getModel().getUnderlyingResource();
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        dialog.setValidator((ISelectionStatusValidator)new FolderValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(MTJUIMessages.L10nLocalesDetails_locationEntryBrowseDialog_title);
        dialog.setMessage(MTJUIMessages.L10nLocalesDetails_locationEntryBrowseDialog_message);
        try {
            dialog.addFilter((ViewerFilter)new SrcFolderFilter(project.getProject(), Utils.getJavaProjectSourceDirectories((IJavaProject)project)));
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        dialog.setInput((Object)MTJUIPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFolder folder = (IFolder)dialog.getFirstResult();
            this.locationEntry.setValue(folder.getProjectRelativePath().toString());
        }
    }

    private void updateDestinationEntry(boolean editable) {
        this.locationEntry.setValue(this.locales.getDestination(), true);
        this.locationEntry.setEditable(editable);
    }

    private void updatePackageEntry(boolean editable) {
        this.packageEntry.setValue(this.locales.getPackage(), true);
        this.packageEntry.setEditable(editable);
    }

    protected String getDetailsDescription() {
        return null;
    }

    protected String getDetailsTitle() {
        return MTJUIMessages.L10nLocalesDetails_detailsTitle;
    }
}

