/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class L10nEntriesTablePage
extends MTJFormPage {
    private static final String KEY_COLUMN_LABEL = "Key";
    private L10nModel model;
    private TableViewer viewer;

    public L10nEntriesTablePage(FormEditor editor) {
        super(editor, "l10nEntriesTablePage", MTJUIMessages.L10nEntriesTablePage_pageTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.model = (L10nModel)this.getModel();
        if (this.model == null || !this.model.isLoaded()) {
            this.createErrorContent(managedForm, this.model);
            return;
        }
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setText(this.getTitle());
        Composite body = form.getBody();
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        body.setLayout((Layout)new GridLayout(1, false));
        this.createL10nEntriesTableSection(managedForm, body);
        form.reflow(true);
    }

    private void createL10nEntriesTableSection(IManagedForm managedForm, Composite body) {
        GridData gridData = null;
        gridData = new GridData(4, 4, true, true);
        Composite section = this.createSection(managedForm, body, MTJUIMessages.L10nEntriesTablePage_sectionTitle, MTJUIMessages.L10nEntriesTablePage_sectionText, gridData);
        section.setLayout((Layout)new GridLayout(1, true));
        this.viewer = new TableViewer(section, 68352);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new L10nEntriesContentProvider());
        this.viewer.setCellModifier((ICellModifier)new L10nEntriesTableCellModifier());
        this.viewer.setLabelProvider((IBaseLabelProvider)new L10nEntriesLabelProvider());
        this.viewer.setInput((Object)this.model);
    }

    private Composite createSection(IManagedForm managedForm, Composite parent, String text, String description, GridData gridData) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        if (text != null) {
            section.setText(text);
        }
        if (description != null) {
            section.setDescription(description);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite client = toolkit.createComposite((Composite)section, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)client);
        return client;
    }

    public void setActive(boolean active) {
        if (active) {
            this.updateColumns(this.model);
        }
    }

    private void updateColumns(L10nModel _model) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TableColumn[] columns;
                Table table = L10nEntriesTablePage.this.viewer.getTable();
                TableColumn[] tableColumnArray = columns = table.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.dispose();
                    ++n2;
                }
                ArrayList<String> names = new ArrayList<String>();
                names.add(L10nEntriesTablePage.KEY_COLUMN_LABEL);
                IDocumentElementNode[] iDocumentElementNodeArray = L10nEntriesTablePage.this.model.getLocales().getChildNodes();
                int n3 = iDocumentElementNodeArray.length;
                n = 0;
                while (n < n3) {
                    IDocumentElementNode node = iDocumentElementNodeArray[n];
                    if (node instanceof L10nLocale) {
                        names.add(((L10nLocale)node).getLocaleName());
                    }
                    ++n;
                }
                L10nEntriesTablePage.this.viewer.setColumnProperties(names.toArray(new String[0]));
                ArrayList<TextCellEditor> editors = new ArrayList<TextCellEditor>();
                for (String name : names) {
                    TableColumn column = new TableColumn(table, 16384);
                    column.setText(name);
                    editors.add(new TextCellEditor((Composite)table));
                }
                L10nEntriesTablePage.this.viewer.setCellEditors(editors.toArray(new CellEditor[0]));
                TableLayout tableLayout = new TableLayout();
                int numColumns = names.size();
                int i = 0;
                while (i < numColumns) {
                    tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100 / numColumns, true));
                    ++i;
                }
                table.setLayout((Layout)tableLayout);
                table.layout(true, true);
                L10nEntriesTablePage.this.viewer.refresh();
            }
        });
    }

    private void createErrorContent(IManagedForm managedForm, L10nModel model) {
        this.createFormErrorContent(managedForm, MTJUIMessages.LocalizationPage_formErrorContent_title, MTJUIMessages.LocalizationPage_formErrorContent_message);
    }

    private class L10nEntriesContentProvider
    implements IStructuredContentProvider,
    IModelChangedListener {
        private Viewer viewer;
        private L10nModel model;

        private L10nEntriesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof L10nModel) {
                L10nModel model = (L10nModel)inputElement;
                result = this.getAllL10nEntries(model);
            }
            return result;
        }

        private L10nEntry[] getAllL10nEntries(L10nModel model) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<L10nEntry> entries = new ArrayList<L10nEntry>();
            L10nLocales locales = model.getLocales();
            IDocumentElementNode[] iDocumentElementNodeArray = locales.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode localesNode = iDocumentElementNodeArray[n2];
                if (localesNode instanceof L10nLocale) {
                    L10nLocale locale = (L10nLocale)localesNode;
                    IDocumentElementNode[] iDocumentElementNodeArray2 = locale.getChildNodes();
                    int n3 = iDocumentElementNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        L10nEntry entry;
                        String key;
                        IDocumentElementNode localeNode = iDocumentElementNodeArray2[n4];
                        if (localeNode instanceof L10nEntry && !keys.contains(key = (entry = (L10nEntry)localeNode).getKey())) {
                            entries.add(entry);
                            keys.add(key);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return entries.toArray(new L10nEntry[0]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof L10nModel) {
                this.model = (L10nModel)newInput;
                this.model.addModelChangedListener((IModelChangedListener)this);
                L10nEntriesTablePage.this.updateColumns(this.model);
            }
            this.viewer = viewer;
        }

        public void dispose() {
            this.viewer = null;
        }

        public void modelChanged(IModelChangedEvent event) {
            if (this.viewer != null) {
                L10nEntriesTablePage.this.updateColumns(this.model);
            }
        }
    }

    private class L10nEntriesLabelProvider
    implements ITableLabelProvider {
        private L10nEntriesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof L10nEntry) {
                L10nEntry entry = (L10nEntry)element;
                result = columnIndex > 0 ? this.resolveKeyValue(entry.getModel(), entry.getKey(), columnIndex - 1) : entry.getKey();
            }
            return result;
        }

        private String resolveKeyValue(L10nModel model, String key, int index) {
            L10nEntry entry;
            String value = null;
            L10nLocales locales = model.getLocales();
            IDocumentElementNode localeNode = locales.getChildAt(index);
            if (localeNode instanceof L10nLocale && (entry = ((L10nLocale)localeNode).getEntry(key)) != null) {
                value = entry.getValue();
            }
            return value;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private class L10nEntriesTableCellModifier
    implements ICellModifier {
        private L10nEntriesTableCellModifier() {
        }

        public Object getValue(Object element, String property) {
            L10nEntry entry;
            L10nEntry other;
            String value = "";
            if (element instanceof L10nEntry && (other = this.resolveKeyEntry((entry = (L10nEntry)element).getModel(), entry.getKey(), property)) != null) {
                value = other.getValue();
            }
            return value;
        }

        private L10nEntry resolveKeyEntry(L10nModel model, String key, String localeName) {
            IDocumentElementNode[] localeNodes;
            L10nEntry result = null;
            L10nLocales locales = model.getLocales();
            IDocumentElementNode[] iDocumentElementNodeArray = localeNodes = locales.getChildNodes();
            int n = localeNodes.length;
            int n2 = 0;
            while (n2 < n) {
                L10nEntry entry;
                L10nLocale locale;
                IDocumentElementNode localeNode = iDocumentElementNodeArray[n2];
                if (localeNode instanceof L10nLocale && (locale = (L10nLocale)localeNode).getLocaleName().equals(localeName) && (entry = locale.getEntry(key)) != null) {
                    result = entry;
                }
                ++n2;
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof L10nEntry) {
                L10nEntry entry = (L10nEntry)element;
                L10nModel model = entry.getModel();
                L10nEntry other = this.resolveKeyEntry(model, entry.getKey(), property);
                if (other == null) {
                    L10nLocale locale = model.getLocales().getLocale(property);
                    if (locale != null) {
                        other = new L10nEntry(model);
                        other.setKey(entry.getKey());
                        other.setValue((String)value);
                        locale.addChild((L10nObject)other);
                    }
                } else {
                    other.setValue((String)value);
                }
            }
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(L10nEntriesTablePage.KEY_COLUMN_LABEL);
        }
    }
}

