/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJMasterDetailsBlock;
import org.eclipse.mtj.internal.ui.editors.l10n.LocalesBlock;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nSourcePage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LocalizationPage
extends MTJFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "localizationPage";
    private LocalesBlock fBlock = new LocalesBlock(this);

    public LocalizationPage(FormEditor editor) {
        super(editor, PAGE_ID, MTJUIMessages.LocalizationPage_title);
    }

    public void dispose() {
        L10nModel l10nModel = (L10nModel)this.getModel();
        if (l10nModel != null) {
            l10nModel.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public MTJMasterDetailsBlock getBlock() {
        return this.fBlock;
    }

    public ISelection getSelection() {
        return this.fBlock.getSelection();
    }

    public void modelChanged(IModelChangedEvent event) {
        this.fBlock.modelChanged(event);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            L10nLocales locales;
            L10nModel l10nModel;
            IFormPage page = this.getMTJEditor().findPage("l10n-context");
            if (page instanceof L10nSourcePage && ((L10nSourcePage)page).getInputContext().isInSourceMode()) {
                ISourceViewer viewer = ((L10nSourcePage)page).getViewer();
                if (viewer == null) {
                    return;
                }
                StyledText text = viewer.getTextWidget();
                if (text == null) {
                    return;
                }
                int offset = text.getCaretOffset();
                if (offset < 0) {
                    return;
                }
                IDocumentRange range = ((L10nSourcePage)page).getRangeElement(offset, true);
                if (range instanceof IDocumentAttributeNode) {
                    range = ((IDocumentAttributeNode)range).getEnclosingElement();
                } else if (range instanceof IDocumentTextNode) {
                    range = ((IDocumentTextNode)range).getEnclosingElement();
                }
                if (range instanceof L10nObject) {
                    this.fBlock.getMasterSection().setSelection((ISelection)new StructuredSelection((Object)range));
                }
            }
            if ((l10nModel = (L10nModel)this.getModel()) != null && (locales = l10nModel.getLocales()) != null && locales.getDefaultLocale() == null) {
                IMessageManager messageManager = this.getManagedForm().getMessageManager();
                messageManager.addMessage((Object)this, MTJUIMessages.L10nLocaleDetails_noDefaultLocale, null, 2);
            }
        }
    }

    private void createErrorContent(IManagedForm managedForm, L10nModel model) {
        this.createFormErrorContent(managedForm, MTJUIMessages.LocalizationPage_formErrorContent_title, MTJUIMessages.LocalizationPage_formErrorContent_message);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        L10nModel model = (L10nModel)this.getModel();
        if (model == null || !model.isLoaded()) {
            this.createErrorContent(managedForm, model);
            return;
        }
        super.createFormContent(managedForm);
        form.setText(MTJUIMessages.LocalizationPage_text);
        this.fBlock.createContent(managedForm);
        this.fBlock.getMasterSection().fireSelection();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/localization/l10nEditorPage.html";
    }
}

