/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.forms.blocks.ButtonBarBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericListBlock<T extends GenericListBlockItem> {
    private List<GenericListBlockListener<T>> listeners;
    private ButtonBarBlock buttonBar;
    private int buttons;
    private TableViewer viewer;
    private List<T> input;

    public GenericListBlock(Composite _parent, int _tableStyle, int _buttons, List<T> _input) {
        if (_input == null) {
            throw new IllegalArgumentException("Input can not be null.");
        }
        this.listeners = new ArrayList<GenericListBlockListener<T>>();
        this.input = _input;
        this.createControl(_parent, _tableStyle, _buttons);
    }

    public void addGenericListBlockListener(GenericListBlockListener<T> _listener) {
        this.listeners.add(_listener);
    }

    public void removeGenericListBlockListener(GenericListBlockListener<T> _listener) {
        this.listeners.remove(_listener);
    }

    private void createControl(Composite parent, int _style, int _buttons) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridLayout layout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(mainComposite, _style);
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new AdvancedListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdvancedListLabelProvider());
        this.viewer.setInput(this.input);
        this.createButtons(mainComposite, _buttons);
    }

    private void createButtons(Composite mainComposite, int _buttons) {
        Composite buttonsComposite = new Composite(mainComposite, 0);
        buttonsComposite.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridData data = new GridData(4, 0x1000000, false, false);
        buttonsComposite.setLayoutData((Object)data);
        FillLayout ButtonBarBlockLayout = new FillLayout(512);
        ButtonBarBlockLayout.spacing = 3;
        buttonsComposite.setLayout((Layout)ButtonBarBlockLayout);
        this.buttons = _buttons | 8 | 0x10;
        this.buttonBar = new ButtonBarBlock(buttonsComposite, this.buttons);
        if ((_buttons & 2) != 0) {
            this.buttonBar.setEnabled(0, true);
            this.buttonBar.getButton(0).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.addButtonPressed();
                    }
                    GenericListBlock.this.updateButtonsStates();
                    GenericListBlock.this.viewer.refresh();
                }
            });
        }
        if ((_buttons & 0x20) != 0) {
            this.buttonBar.setEnabled(4, true);
            this.buttonBar.getButton(4).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.scan();
                    }
                }
            });
        }
        if ((_buttons & 4) != 0) {
            this.buttonBar.setEnabled(1, this.input.size() > 0);
            this.buttonBar.getButton(1).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    ISelection selection = GenericListBlock.this.viewer.getSelection();
                    if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    List items = structuredSelection.toList();
                    if (items.size() == 0) {
                        return;
                    }
                    for (Object item : items) {
                        GenericListBlock.this.input.remove(item);
                    }
                    GenericListBlock.this.updateButtonsStates();
                    GenericListBlock.this.viewer.refresh();
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.itemsRemoved(items);
                    }
                }
            });
        }
        if (this.input.size() > 1) {
            this.buttonBar.setEnabled(2, true);
            this.buttonBar.setEnabled(3, true);
        }
        this.buttonBar.getButton(2).addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ISelection selection = GenericListBlock.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                List items = structuredSelection.toList();
                if (items.size() > 1) {
                    return;
                }
                GenericListBlockItem item = (GenericListBlockItem)structuredSelection.getFirstElement();
                int index = GenericListBlock.this.input.indexOf(item);
                if (index > 0) {
                    GenericListBlock.this.input.remove(index);
                    GenericListBlock.this.input.add(--index, item);
                    GenericListBlock.this.viewer.refresh();
                }
                for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                    listener.upButtonPressed();
                }
            }
        });
        this.buttonBar.getButton(3).addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ISelection selection = GenericListBlock.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                List items = structuredSelection.toList();
                if (items.size() > 1) {
                    return;
                }
                GenericListBlockItem item = (GenericListBlockItem)structuredSelection.getFirstElement();
                int index = GenericListBlock.this.input.indexOf(item);
                if (index < GenericListBlock.this.input.size() - 1) {
                    GenericListBlock.this.input.remove(index);
                    GenericListBlock.this.input.add(++index, item);
                    GenericListBlock.this.viewer.refresh();
                }
                for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                    listener.downButtonPressed();
                }
            }
        });
    }

    private void updateButtonsStates() {
        if (this.viewer.getControl().isEnabled()) {
            if ((this.buttons & 4) != 0) {
                this.buttonBar.setEnabled(1, this.input.size() > 0);
            }
            this.buttonBar.setEnabled(2, this.input.size() > 1);
            this.buttonBar.setEnabled(3, this.input.size() > 1);
        }
    }

    public void update() {
        this.updateButtonsStates();
        this.viewer.refresh();
    }

    public void setEnabled(boolean state) {
        this.viewer.getControl().setEnabled(state);
        this.buttonBar.setEnabled(state);
        this.updateButtonsStates();
    }

    private class AdvancedListContentProvider
    implements IStructuredContentProvider {
        private AdvancedListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List items = (List)inputElement;
                return items.toArray(new GenericListBlockItem[items.size()]);
            }
            return null;
        }

        public void dispose() {
        }
    }

    private class AdvancedListLabelProvider
    extends LabelProvider {
        private AdvancedListLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof GenericListBlockItem) {
                image = ((GenericListBlockItem)element).getImage();
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof GenericListBlockItem) {
                text = ((GenericListBlockItem)element).getText();
            }
            return text;
        }
    }
}

