/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SELECT_MAIN_METHOD_DIALOG = "org.eclipse.jdt.debug.ui.select_main_method_dialog";
    private static final String SETTINGS_ID = "org.eclipse.mtj.ui.MIDLET_SELECTION_DIALOG";
    private IType[] fTypes = null;

    public DebugTypeSelectionDialog(Shell shell, IType[] elements, String title) {
        super(shell, false);
        this.setTitle(title);
        this.fTypes = elements;
        this.setMessage(MTJUIMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        this.setInitialPattern("**");
        this.setListLabelProvider(new DebugTypeLabelProvider());
        this.setDetailsLabelProvider(new DebugTypeDetailsLabelProvider());
        this.setSelectionHistory(new DebugTypeSelectionHistory());
    }

    public String getElementName(Object item) {
        if (item instanceof IType) {
            return ((IType)item).getElementName();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, SELECT_MAIN_METHOD_DIALOG);
        return ctrl;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DebugTypeItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.fTypes != null && this.fTypes.length > 0) {
            IType[] iTypeArray = this.fTypes;
            int n = this.fTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType element = iTypeArray[n2];
                if (itemsFilter.isConsistentItem((Object)element)) {
                    contentProvider.add((Object)element, itemsFilter);
                }
                ++n2;
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = MTJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Comparator<IType> getItemsComparator() {
        Comparator<IType> comp = new Comparator<IType>(){

            @Override
            public int compare(IType o1, IType o2) {
                return o1.getElementName().compareTo(o2.getElementName());
            }
        };
        return comp;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    class DebugTypeDetailsLabelProvider
    extends DebugTypeLabelProvider {
        DebugTypeDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IType) {
                return super.getImage(this.getDeclaringContainer((IType)element));
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            IType type;
            String name;
            if (element instanceof IType && (name = this.getDeclaringContainerName(type = (IType)element)) != null) {
                if (name.equals(MTJUIMessages.MainMethodLabelProvider_0)) {
                    IJavaProject project = type.getJavaProject();
                    if (project != null) {
                        try {
                            return String.valueOf(project.getOutputLocation().toOSString().substring(1)) + " - " + name;
                        }
                        catch (JavaModelException e) {
                            MTJLogger.log((int)4, (Throwable)e);
                        }
                    }
                } else {
                    return name;
                }
            }
            return null;
        }
    }

    class DebugTypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        DebugTypeItemsFilter() {
            super((FilteredItemsSelectionDialog)DebugTypeSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof IType;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IType) || !Arrays.asList(DebugTypeSelectionDialog.this.fTypes).contains(item)) {
                return false;
            }
            return this.matches(((IType)item).getElementName());
        }
    }

    public class DebugTypeLabelProvider
    implements ILabelProvider {
        HashMap<ImageDescriptor, Image> fImageMap = new HashMap();

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.fImageMap.clear();
            this.fImageMap = null;
        }

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                Image image = this.fImageMap.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    this.fImageMap.put(descriptor, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IType) {
                IType type = (IType)element;
                String label = type.getElementName();
                String container = this.getDeclaringContainerName(type);
                if (container != null && !"".equals(container)) {
                    label = String.valueOf(label) + " - " + container;
                }
                return label;
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        protected IJavaElement getDeclaringContainer(IType type) {
            IType outer = type.getDeclaringType();
            if (outer == null) {
                outer = type.getPackageFragment();
            }
            return outer;
        }

        protected String getDeclaringContainerName(IType type) {
            IType outer = type.getDeclaringType();
            if (outer != null) {
                return outer.getFullyQualifiedName('.');
            }
            String name = type.getPackageFragment().getElementName();
            if ("".equals(name)) {
                name = MTJUIMessages.MainMethodLabelProvider_0;
            }
            return name;
        }
    }

    class DebugTypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        DebugTypeSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            IJavaElement element = JavaCore.create((String)memento.getTextData());
            return element instanceof IType ? element : null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IType) {
                memento.putTextData(((IType)item).getHandleIdentifier());
            }
        }
    }
}

