/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class MTJConsoleHyperLink
implements IHyperlink {
    private StackTraceEntry stackEntry;

    public MTJConsoleHyperLink(StackTraceEntry _stackEntry) {
        this.stackEntry = _stackEntry;
    }

    public void linkActivated() {
        File sourceFile = this.stackEntry.getJavaFile();
        int line = this.stackEntry.getLine() - 1;
        if (sourceFile != null) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(sourceFile.getName());
                IFile[] files = MTJCore.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(sourceFile.getAbsolutePath()));
                IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(files[0]), desc.getId());
                ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(line), document.getLineLength(line) - 1);
            }
            catch (PartInitException e) {
                MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
            }
            catch (BadLocationException e) {
                MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

