/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.LinedStackTraceParser;
import org.eclipse.mtj.internal.core.launching.OffsetedStackTraceParser;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.mtj.internal.core.launching.StackTraceParser;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.launching.BCIStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.LinedStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.OffsetedStackTraceMatcher;
import org.eclipse.mtj.internal.ui.launching.StackTraceMatcher;
import org.eclipse.ui.console.IPatternMatchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJConsoleLineTracker
implements IConsoleLineTracker {
    private Map<String, StackTraceEntry> cachedTrace;
    private IJavaProject project;
    private IConsole console;

    public void init(IConsole console) {
        this.cachedTrace = new Hashtable<String, StackTraceEntry>();
        this.console = console;
        try {
            IProject project;
            ILaunchConfiguration configuration = console.getProcess().getLaunch().getLaunchConfiguration();
            String projectName = configuration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            if (projectName.length() > 0 && (project = MTJCore.getWorkspace().getRoot().getProject(projectName)).isOpen() && project.hasNature("org.eclipse.mtj.core.nature")) {
                this.project = JavaCore.create((IProject)project);
                StackTraceMatcher matcher = null;
                OffsetedStackTraceParser parser = null;
                parser = new OffsetedStackTraceParser(this.project);
                matcher = new OffsetedStackTraceMatcher(this, (StackTraceParser)parser);
                this.console.addPatternMatchListener((IPatternMatchListener)matcher);
                matcher = new BCIStackTraceMatcher(this, (StackTraceParser)parser);
                this.console.addPatternMatchListener((IPatternMatchListener)matcher);
                parser = new LinedStackTraceParser(this.project);
                matcher = new LinedStackTraceMatcher(this, (StackTraceParser)parser);
                this.console.addPatternMatchListener((IPatternMatchListener)matcher);
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineAppended(IRegion region) {
        block6: {
            try {
                String trace = this.console.getDocument().get(region.getOffset(), region.getLength());
                if (!Pattern.matches("(\tat .+[(].*[.java][:]\\d+[)])", trace) && !Pattern.matches("(\tat .+[(][+]\\d+[)])", trace) && !Pattern.matches("(\\s[-]\\s.+[,]\\s(bci=)\\d+)", trace)) break block6;
                StackTraceEntry element = null;
                Map<String, StackTraceEntry> map = this.cachedTrace;
                synchronized (map) {
                    element = this.cachedTrace.get(trace);
                    if (element == null) {
                        element = new StackTraceEntry(trace);
                        this.cachedTrace.put(trace, element);
                    }
                }
                element.addRegion(region);
            }
            catch (BadLocationException e) {
                MTJLogger.log((int)4, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, StackTraceEntry> getCachedTrace() {
        return this.cachedTrace;
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void dispose() {
        this.console = null;
    }
}

