/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.launching.JavaLaunchShortcut;
import org.eclipse.mtj.internal.ui.launching.MidletLaunchConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletLaunchShortcut
extends JavaLaunchShortcut {
    @Override
    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String launchConfigName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchConfigName);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, Utils.getQualifiedClassName((IType)type));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute("mtj.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"debug", (String)"perspective_default");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            MTJLogger.log((int)2, (String)"createConfiguration", (Throwable)ce);
        }
        return config;
    }

    @Override
    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            return MidletLaunchConfigUtils.findMidlets(context, elements);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    @Override
    protected List<ILaunchConfiguration> getCandidateConfigs(IType type, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                boolean doJadLaunch = config.getAttribute("mtj.do_jad_launch", false);
                String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                String midletName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
                if (!doJadLaunch && projectName.equals(type.getJavaProject().getElementName()) && midletName.equals(type.getFullyQualifiedName())) {
                    candidateConfigs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MTJLogger.log((int)2, (String)"getCandidateConfigs", (Throwable)e);
        }
        return candidateConfigs;
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("MTJ.emulatorLaunchConfigurationType");
        return configType;
    }

    @Override
    protected String getEditorEmptyMessage() {
        return MTJUIMessages.MidletLaunching_EditorContainsNoMidlet;
    }

    @Override
    protected String getSelectionEmptyMessage() {
        return MTJUIMessages.MidletLaunching_SelectionContainsNoMidlet;
    }

    @Override
    protected String getTypeSelectionTitle() {
        return MTJUIMessages.MidletLaunching_SelectionDialogTitle;
    }
}

