/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.parts;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mtj.internal.ui.parts.SharedPartWithButtons;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private Point fMinSize;
    private StructuredViewer fViewer;

    public StructuredViewerPart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    public StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void setMinimumSize(int width, int height) {
        this.fMinSize = new Point(width, height);
        if (this.fViewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.fMinSize != null) {
            GridData gd = (GridData)this.fViewer.getControl().getLayoutData();
            gd.widthHint = this.fMinSize.x;
            gd.heightHint = this.fMinSize.y;
        }
    }

    protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fViewer = this.createStructuredViewer(parent, style, toolkit);
        Control control = this.fViewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormToolkit var3);

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }
}

