/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.ISDKProvider;
import org.eclipse.mtj.core.sdk.ManagedSDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.ImportedSDKProvider;
import org.eclipse.mtj.internal.core.sdk.SDKProviderRegistry;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceEditorConfigElement;
import org.eclipse.mtj.internal.ui.devices.DeviceEditorRegistry;
import org.eclipse.mtj.internal.ui.devices.DeviceImportWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.deviceManagementPreferencePage";
    private static final int DEFAULT_COLUMN_IDX = 1;
    private static final String DEFAULT_MARKER = "\u25cf\u25cf";
    private Tree deviceTree;
    private Button deleteButton;
    private Button duplicateButton;
    private Button editButton;
    private Button setDefaultButton;
    private Button importButton;
    private IAction editAction;
    private IActionDelegate editDelegate;
    private IWorkbench workbench;
    private Font boldFont;
    private Image IMG_FOLDER;
    private Image IMG_CELLPHONE;

    public DeviceManagementPreferencePage() {
        super(MTJUIMessages.DeviceManagementPreferencePage_title);
        this.setDescription(String.valueOf(MTJUIMessages.DeviceManagementPreferencePage_description) + "\n\n" + MTJUIMessages.DeviceManagementPreferencePage_instaled_sdks_label);
        this.setPreferenceStore(MTJUIPlugin.getDefault().getCorePreferenceStore());
        this.noDefaultAndApplyButton();
        this.editAction = new Action(){};
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.IMG_FOLDER = images.getImage("IMG_OBJ_FOLDER");
        this.IMG_CELLPHONE = MTJUIPluginImages.DESC_CELLPHONE_OBJ.createImage();
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        container.setFont(parent.getFont());
        try {
            DeviceRegistry.getInstance().load();
        }
        catch (Exception e) {
            MTJLogger.log((int)4, (Throwable)e);
            this.createErrorContents(container, e);
            return container;
        }
        try {
            this.createDeviceContents(container);
        }
        catch (Exception e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.mtj.ui.help_DeviceManagementPage");
        return container;
    }

    private Control createDeviceContents(Composite parent) {
        FontData[] fontData;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 475;
        gridData.heightHint = 400;
        this.deviceTree = new Tree(composite, 2818);
        this.deviceTree.setHeaderVisible(true);
        this.deviceTree.setLayoutData((Object)gridData);
        this.deviceTree.setLinesVisible(true);
        this.deviceTree.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                DeviceManagementPreferencePage.this.handleTreeDoubleClick();
            }
        });
        this.deviceTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.handleTreeSelection();
            }
        });
        this.deviceTree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                DeviceManagementPreferencePage.this.adjustDefaultMarker();
            }

            public void treeExpanded(TreeEvent e) {
                DeviceManagementPreferencePage.this.adjustDefaultMarker();
            }
        });
        TreeColumn deviceNameColumn = new TreeColumn(this.deviceTree, 16384);
        deviceNameColumn.setText(MTJUIMessages.DeviceManagementPreferencePage_name_columnInfo);
        deviceNameColumn.setWidth(315);
        deviceNameColumn.setAlignment(16384);
        TreeColumn defaultColumn = new TreeColumn(this.deviceTree, 0x1000000, 1);
        defaultColumn.setText(MTJUIMessages.DeviceManagementPreferencePage_default_columnInfo);
        defaultColumn.setWidth(55);
        TreeColumn cldcColumn = new TreeColumn(this.deviceTree, 16384);
        cldcColumn.setText(MTJUIMessages.DeviceManagementPreferencePage_configuration_columnInfo);
        cldcColumn.setWidth(80);
        TreeColumn midpColumn = new TreeColumn(this.deviceTree, 16384);
        midpColumn.setText(MTJUIMessages.DeviceManagementPreferencePage_profile_columnInfo);
        midpColumn.setWidth(60);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        buttonComposite.setLayoutData((Object)new GridData(1040));
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(MTJUIMessages.DeviceManagementPreferencePage_editButton_lable_text);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.updateButtonEnablement();
                DeviceManagementPreferencePage.this.updateEditDelegate();
                DeviceManagementPreferencePage.this.handleEditDevice();
            }
        });
        this.duplicateButton = new Button(buttonComposite, 8);
        this.duplicateButton.setLayoutData((Object)new GridData(768));
        this.duplicateButton.setText(MTJUIMessages.DeviceManagementPreferencePage_duplicateButton_label_text);
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.handleDuplicate();
            }
        });
        this.deleteButton = new Button(buttonComposite, 8);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setText(MTJUIMessages.DeviceManagementPreferencePage_deleteButton_label_text);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.handleDelete();
            }
        });
        this.setDefaultButton = new Button(buttonComposite, 8);
        this.setDefaultButton.setLayoutData((Object)new GridData(768));
        this.setDefaultButton.setText(MTJUIMessages.DeviceManagementPreferencePage_setDefaultButton_label_text);
        this.setDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.handleSetDefault();
            }
        });
        new Label(buttonComposite, 0);
        this.importButton = new Button(buttonComposite, 8);
        this.importButton.setLayoutData((Object)new GridData(768));
        this.importButton.setText(MTJUIMessages.DeviceManagementPreferencePage_importButton_label_text);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceManagementPreferencePage.this.handleImport();
            }
        });
        FontData[] fontDataArray = fontData = this.deviceTree.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDatum = fontDataArray[n2];
            fontDatum.setStyle(fontDatum.getStyle() | 1);
            ++n2;
        }
        Display display = Display.getDefault();
        this.boldFont = new Font((Device)display, fontData);
        this.refreshDeviceTree();
        this.doDefaultTreeExpand();
        this.updateEditDelegate();
        this.updateButtonEnablement();
        this.selectStartingDefaultDevice();
        return composite;
    }

    private Control createErrorContents(Composite parent, Exception e) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        String text = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_reading_device_registry, (Object[])new String[]{e.getClass().getName(), e.getMessage()});
        Text errorText = new Text(composite, 2122);
        errorText.setLayoutData((Object)new GridData(4, 4, true, true));
        errorText.setText(text);
        return composite;
    }

    private void refreshDeviceTree() {
        this.deviceTree.setRedraw(false);
        this.deviceTree.removeAll();
        IDevice defaultDevice = DeviceRegistry.getInstance().getDefaultDevice();
        List providers = SDKProviderRegistry.getInstance().getSDKProviders();
        Collections.sort(providers);
        providers.add(0, ImportedSDKProvider.getInstance());
        for (ISDKProvider provider : providers) {
            List sdks = provider.getSDKs();
            if (sdks.size() < 1) continue;
            TreeItem providerTreeItem = new TreeItem(this.deviceTree, 0);
            providerTreeItem.setData((Object)new MTJObject(provider));
            providerTreeItem.setText(provider.getName());
            Image providerLogo = provider.getLogo();
            if (provider.getLogo() != null) {
                providerTreeItem.setImage(providerLogo);
            } else {
                providerTreeItem.setImage(this.IMG_FOLDER);
            }
            providerTreeItem.setFont(this.boldFont);
            if (sdks.size() > 1) {
                TreeMap<String, ISDK> sortedSdks = new TreeMap<String, ISDK>();
                for (ISDK sdk : provider.getSDKs()) {
                    sortedSdks.put(sdk.getName(), sdk);
                }
                sdks.clear();
                sdks.addAll(sortedSdks.values());
            }
            for (ISDK sdk : sdks) {
                List devices;
                try {
                    devices = sdk.getDeviceList();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    continue;
                }
                if (devices.size() < 1) continue;
                TreeItem sdkTreeItem = new TreeItem(providerTreeItem, 0);
                sdkTreeItem.setData((Object)new MTJObject(sdk));
                sdkTreeItem.setText(sdk.getName());
                if (sdk instanceof ManagedSDK) {
                    sdkTreeItem.setImage(MTJUIPluginImages.DESC_IU_OBJ.createImage());
                } else {
                    sdkTreeItem.setImage(this.IMG_FOLDER);
                }
                if (devices.size() >= 1) {
                    TreeMap<String, IDevice> sortedDevices = new TreeMap<String, IDevice>();
                    for (IDevice device : devices) {
                        sortedDevices.put(device.getName(), device);
                    }
                    devices.clear();
                    devices.addAll(sortedDevices.values());
                }
                for (IDevice device : devices) {
                    TreeItem deviceTreeItem = new TreeItem(sdkTreeItem, 0);
                    deviceTreeItem.setData((Object)new MTJObject(device));
                    String displayedName = device.getName();
                    String defaultString = "";
                    if (defaultDevice != null && device.getName().equals(defaultDevice.getName()) && device.getSDKName().equals(defaultDevice.getSDKName())) {
                        defaultString = DEFAULT_MARKER;
                    }
                    String configuration = "";
                    String profile = "";
                    if (device instanceof IMIDPDevice) {
                        IMIDPAPI midpApi;
                        IMIDPAPI cldcApi = ((IMIDPDevice)device).getCLDCAPI();
                        if (cldcApi != null) {
                            configuration = cldcApi.toString();
                        }
                        if ((midpApi = ((IMIDPDevice)device).getMIDPAPI()) != null) {
                            profile = midpApi.toString();
                        }
                    }
                    deviceTreeItem.setText(new String[]{displayedName, defaultString, configuration, profile});
                    deviceTreeItem.setImage(this.IMG_CELLPHONE);
                }
            }
        }
        this.deviceTree.setRedraw(true);
    }

    private void doDefaultTreeExpand() {
        TreeItem[] providerItems;
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] sdkItems;
            TreeItem providerItem = treeItemArray[n2];
            providerItem.setExpanded(true);
            TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
            int n3 = sdkItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem sdkItem = treeItemArray2[n4];
                sdkItem.setExpanded(true);
                ++n4;
            }
            ++n2;
        }
    }

    private void toggleExpansionOnSelectedItem() {
        TreeItem[] treeItems = this.deviceTree.getSelection();
        if (treeItems.length == 1) {
            treeItems[0].setExpanded(!treeItems[0].getExpanded());
            this.adjustDefaultMarker();
        }
    }

    private List<String> recordProviderAndSdkExpansionStates() {
        TreeItem[] providerItems;
        ArrayList<String> list = new ArrayList<String>();
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem providerItem = treeItemArray[n2];
            if (providerItem.getExpanded()) {
                TreeItem[] sdkItems;
                MTJObject providerObject = (MTJObject)providerItem.getData();
                list.add(providerObject.getSdkProvider().getName());
                TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
                int n3 = sdkItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    MTJObject sdkObject;
                    TreeItem sdkItem = treeItemArray2[n4];
                    if (sdkItem.getExpanded() && (sdkObject = (MTJObject)sdkItem.getData()) != null) {
                        list.add(sdkObject.getSdk().getName());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return list;
    }

    private void replayItemExpansionStates(List<String> expansionSnapshot) {
        TreeItem[] providerItems;
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem providerItem = treeItemArray[n2];
            if (expansionSnapshot.contains(providerItem.getText())) {
                TreeItem[] sdkItems;
                providerItem.setExpanded(true);
                TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
                int n3 = sdkItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem sdkItem = treeItemArray2[n4];
                    sdkItem.setExpanded(expansionSnapshot.contains(sdkItem.getText()));
                    ++n4;
                }
            }
            ++n2;
        }
        this.adjustDefaultMarker();
    }

    private void adjustDefaultMarker() {
        TreeItem[] providerItems;
        TreeItem defaultTreeItem = null;
        TreeItem sdkTreeItem = null;
        TreeItem providerTreeItem = null;
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] sdkItems;
            TreeItem providerItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
            int n3 = sdkItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem[] deviceItems;
                TreeItem sdkItem = treeItemArray2[n4];
                TreeItem[] treeItemArray3 = deviceItems = sdkItem.getItems();
                int n5 = deviceItems.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem deviceItem = treeItemArray3[n6];
                    MTJObject mtjObject = (MTJObject)deviceItem.getData();
                    IDevice thisDevice = mtjObject.getDevice();
                    if (this.isDefaultDevice(thisDevice)) {
                        providerTreeItem = providerItem;
                        sdkTreeItem = sdkItem;
                        defaultTreeItem = deviceItem;
                        break;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        if (defaultTreeItem != null) {
            final TreeItem finalSdkTreeItem = sdkTreeItem;
            final TreeItem finalProviderTreeItem = providerTreeItem;
            Runnable treeRefresh = new Runnable(){

                public void run() {
                    finalSdkTreeItem.setText(1, "");
                    finalProviderTreeItem.setText(1, "");
                    if (!finalProviderTreeItem.getExpanded()) {
                        finalProviderTreeItem.setText(1, DeviceManagementPreferencePage.DEFAULT_MARKER);
                    } else if (!finalSdkTreeItem.getExpanded()) {
                        finalSdkTreeItem.setText(1, DeviceManagementPreferencePage.DEFAULT_MARKER);
                    }
                }
            };
            this.deviceTree.getDisplay().asyncExec(treeRefresh);
        }
    }

    private MTJObject getSelectedMTJObject() {
        TreeItem[] treeItems = this.deviceTree.getSelection();
        if (treeItems.length == 1) {
            return (MTJObject)treeItems[0].getData();
        }
        return null;
    }

    private List<MTJObject> getSelectedMTJObjects() {
        TreeItem[] treeItems;
        ArrayList<MTJObject> list = new ArrayList<MTJObject>();
        TreeItem[] treeItemArray = treeItems = this.deviceTree.getSelection();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            list.add((MTJObject)treeItem.getData());
            ++n2;
        }
        return list;
    }

    private IDevice getSelectedDevice() {
        MTJObject mtjObject = this.getSelectedMTJObject();
        if (mtjObject != null && mtjObject.isDevice) {
            return mtjObject.getDevice();
        }
        return null;
    }

    private void setSelectedDevice(IDevice device) {
        TreeItem[] providerItems;
        this.deviceTree.redraw();
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] sdkItems;
            TreeItem providerItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
            int n3 = sdkItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem[] deviceItems;
                TreeItem sdkItem = treeItemArray2[n4];
                TreeItem[] treeItemArray3 = deviceItems = sdkItem.getItems();
                int n5 = deviceItems.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem deviceItem = treeItemArray3[n6];
                    MTJObject mtjObject = (MTJObject)deviceItem.getData();
                    IDevice thisDevice = mtjObject.getDevice();
                    if (device == thisDevice) {
                        this.deviceTree.setSelection(deviceItem);
                        this.deviceTree.setFocus();
                        return;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void setSelectedDevices(List<IDevice> devices) {
        TreeItem[] providerItems;
        TreeItem[] treeItems = new TreeItem[devices.size()];
        int idx = 0;
        this.deviceTree.redraw();
        TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
        int n = providerItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem[] sdkItems;
            TreeItem providerItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
            int n3 = sdkItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem[] deviceItems;
                TreeItem sdkItem = treeItemArray2[n4];
                TreeItem[] treeItemArray3 = deviceItems = sdkItem.getItems();
                int n5 = deviceItems.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeItem deviceItem = treeItemArray3[n6];
                    MTJObject mtjObject = (MTJObject)deviceItem.getData();
                    if (devices.contains(mtjObject.getDevice())) {
                        treeItems[idx] = deviceItem;
                        ++idx;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        this.deviceTree.setSelection(treeItems);
        this.deviceTree.setFocus();
    }

    private TreeItem getTreeItem(MTJObject mtjObject) {
        TreeItem[] treeItems;
        TreeItem[] treeItemArray = treeItems = this.deviceTree.getSelection();
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            MTJObject object = (MTJObject)treeItem.getData();
            if (object == mtjObject) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    private void handleSetDefault() {
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice != null) {
            DeviceRegistry.getInstance().setDefaultDevice(selectedDevice);
            List<String> expandedTreeItems = this.recordProviderAndSdkExpansionStates();
            this.deviceTree.setRedraw(false);
            this.refreshDeviceTree();
            this.replayItemExpansionStates(expandedTreeItems);
            this.setSelectedDevice(selectedDevice);
            this.deviceTree.setRedraw(true);
            this.updateButtonEnablement();
        }
    }

    private void handleDelete() {
        ArrayList<IDevice> selectedDevices = new ArrayList<IDevice>();
        List<MTJObject> mtjObjects = this.getSelectedMTJObjects();
        MTJObject sampleMtjObject = mtjObjects.get(0);
        TreeItem[] selectionsSnapshot = this.deviceTree.getSelection();
        List<String> expandedSnapshot = this.recordProviderAndSdkExpansionStates();
        if (sampleMtjObject.isDevice) {
            for (MTJObject deviceObject : mtjObjects) {
                selectedDevices.add(deviceObject.getDevice());
            }
        } else if (sampleMtjObject.isSdk) {
            for (MTJObject sdkObject : mtjObjects) {
                TreeItem sdkItem = this.getTreeItem(sdkObject);
                if (sdkItem != null) {
                    sdkItem.setExpanded(true);
                }
                ISDK sdk = sdkObject.getSdk();
                try {
                    selectedDevices.addAll(sdk.getDeviceList());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (sampleMtjObject.isSdkProvider) {
            for (MTJObject providerObject : mtjObjects) {
                TreeItem providerItem = this.getTreeItem(providerObject);
                if (providerItem != null) {
                    TreeItem[] sdkItems;
                    providerItem.setExpanded(true);
                    TreeItem[] treeItemArray = sdkItems = providerItem.getItems();
                    int n = sdkItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem sdkItem = treeItemArray[n2];
                        sdkItem.setExpanded(true);
                        ++n2;
                    }
                }
                ISDKProvider provider = providerObject.getSdkProvider();
                List sdks = provider.getSDKs();
                for (ISDK sdk : sdks) {
                    try {
                        selectedDevices.addAll(sdk.getDeviceList());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (selectedDevices.isEmpty()) {
            return;
        }
        this.setSelectedDevices(selectedDevices);
        int count = selectedDevices.size();
        String title = MTJUIMessages.DeviceManagementPreferencePage_confirm_delete_dialog_title;
        String message = NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_confirm_delet_dialog_message, (Object)count);
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message)) {
            for (IDevice device : selectedDevices) {
                if (device instanceof IManagedDevice) {
                    ISDK sdk = device.getSDK();
                    ManagedSDK managedSDK = (ManagedSDK)sdk;
                    managedSDK.deleteDuplicateDevice((IManagedDevice)device);
                    continue;
                }
                try {
                    if (ImportedSDKProvider.getInstance().removeDevice(device)) continue;
                    throw new PersistenceException();
                }
                catch (PersistenceException e) {
                    this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_remove_device, e);
                }
            }
            this.refreshDeviceTree();
            this.updateButtonEnablement();
            this.selectStartingDefaultDevice();
        }
        this.replayItemExpansionStates(expandedSnapshot);
        this.deviceTree.setSelection(selectionsSnapshot);
        this.updateButtonEnablement();
    }

    private void handleDuplicate() {
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            return;
        }
        ISDK sdk = selectedDevice.getSDK();
        IDevice duplicate = null;
        String uniqueName = this.findUniqueName(selectedDevice);
        duplicate = sdk instanceof ManagedSDK ? ((ManagedSDK)sdk).duplicateDevice((IManagedDevice)selectedDevice, uniqueName) : ImportedSDKProvider.getInstance().duplicateDevice(selectedDevice, uniqueName);
        try {
            if (duplicate == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(MTJUIMessages.DeviceManagementPreferencePage_error_duplicated_device, e);
        }
        List<String> expandedTreeItems = this.recordProviderAndSdkExpansionStates();
        this.refreshDeviceTree();
        this.replayItemExpansionStates(expandedTreeItems);
        this.setSelectedDevice(duplicate);
        this.updateButtonEnablement();
    }

    private void handleEditDevice() {
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice instanceof IMIDPDevice && this.editDelegate != null) {
            this.editDelegate.run(this.editAction);
        }
    }

    private void handleImport() {
        DeviceImportWizard wizard = new DeviceImportWizard();
        WizardDialog dialog = new WizardDialog(this.workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.refreshDeviceTree();
            this.updateButtonEnablement();
            this.doDefaultTreeExpand();
            this.selectStartingDefaultDevice();
        }
    }

    private void handleTreeDoubleClick() {
        MTJObject mtjObject = this.getSelectedMTJObject();
        if (mtjObject != null) {
            if (mtjObject.canExpand) {
                this.toggleExpansionOnSelectedItem();
            } else if (mtjObject.canEdit) {
                this.updateButtonEnablement();
                this.updateEditDelegate();
                this.handleEditDevice();
            }
        }
    }

    private void handleTreeSelection() {
        this.updateEditDelegate();
        this.updateButtonEnablement();
    }

    public boolean performOk() {
        boolean wasOK = false;
        try {
            DeviceRegistry.getInstance().store();
            wasOK = true;
        }
        catch (Exception e) {
            MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_title, MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_dialog_message, e);
            MTJLogger.log((int)4, (String)NLS.bind((String)MTJUIMessages.DeviceManagementPreferencePage_error_storing_devises_log_msg, (Object[])new String[]{e.getClass().getName(), e.getMessage()}), (Throwable)e);
        }
        return wasOK;
    }

    private void updateEditDelegate() {
        this.editDelegate = null;
        IDevice device = this.getSelectedDevice();
        if (device instanceof AbstractMIDPDevice) {
            AbstractMIDPDevice midpDevice = (AbstractMIDPDevice)device;
            TreePath tp = new TreePath((Object[])new AbstractMIDPDevice[]{midpDevice});
            TreeSelection selection = new TreeSelection(tp);
            this.editDelegate = this.findActionDelegate(device);
            if (this.editDelegate != null) {
                this.editDelegate.selectionChanged(this.editAction, (ISelection)selection);
            }
        }
    }

    private void updateButtonEnablement() {
        List<MTJObject> mtjObjects = this.getSelectedMTJObjects();
        if (mtjObjects.size() == 1) {
            MTJObject mtjObject = mtjObjects.get(0);
            this.duplicateButton.setEnabled(mtjObject.canDuplicate);
            this.editButton.setEnabled(mtjObject.canEdit && this.editDelegate != null && this.editAction.isEnabled());
            IDevice selectedDevice = mtjObject.getDevice();
            this.setDefaultButton.setEnabled(mtjObject.canSetDefault && !this.isDefaultDevice(selectedDevice));
        } else {
            this.duplicateButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(this.canDoDelete(mtjObjects));
    }

    private boolean canDoDelete(List<MTJObject> selectedMtjObjects) {
        if (selectedMtjObjects.isEmpty()) {
            return false;
        }
        int providerCount = 0;
        int sdkCount = 0;
        int deviceCount = 0;
        for (MTJObject thisMtjObject : selectedMtjObjects) {
            if (!thisMtjObject.canDelete) {
                return false;
            }
            if (thisMtjObject.isSdkProvider) {
                ++providerCount;
                continue;
            }
            if (thisMtjObject.isSdk) {
                ++sdkCount;
                continue;
            }
            if (!thisMtjObject.isDevice) continue;
            ++deviceCount;
        }
        return (providerCount <= 0 || sdkCount <= 0 && deviceCount <= 0) && (sdkCount <= 0 || providerCount <= 0 && deviceCount <= 0) && (deviceCount <= 0 || sdkCount <= 0 && providerCount <= 0);
    }

    private void selectStartingDefaultDevice() {
        if (DeviceRegistry.getInstance().getDefaultDevice() == null) {
            TreeItem[] providerItems;
            TreeItem[] treeItemArray = providerItems = this.deviceTree.getItems();
            int n = providerItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem[] sdkItems;
                TreeItem providerItem = treeItemArray[n2];
                TreeItem[] treeItemArray2 = sdkItems = providerItem.getItems();
                int n3 = sdkItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem[] deviceItems;
                    TreeItem sdkItem = treeItemArray2[n4];
                    TreeItem[] treeItemArray3 = deviceItems = sdkItem.getItems();
                    int n5 = deviceItems.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem deviceItem = treeItemArray3[n6];
                        MTJObject mtjObject = (MTJObject)deviceItem.getData();
                        if (mtjObject.isDevice) {
                            IDevice device = mtjObject.getDevice();
                            DeviceRegistry.getInstance().setDefaultDevice(device);
                            List<String> expandedTreeItems = this.recordProviderAndSdkExpansionStates();
                            this.refreshDeviceTree();
                            this.replayItemExpansionStates(expandedTreeItems);
                            return;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private boolean isDefaultDevice(IDevice device) {
        if (device == null) {
            return false;
        }
        String deviceName = device.getName();
        if (deviceName == null) {
            return false;
        }
        String deviceSdkName = device.getSDKName();
        if (deviceSdkName == null) {
            return false;
        }
        IDevice defaultDevice = DeviceRegistry.getInstance().getDefaultDevice();
        if (defaultDevice == null) {
            return false;
        }
        String defaultDeviceName = defaultDevice.getName();
        if (defaultDeviceName == null) {
            return false;
        }
        String defaultDeviceSdkName = defaultDevice.getSDKName();
        if (defaultDeviceSdkName == null) {
            return false;
        }
        return defaultDeviceName.equals(deviceName) && defaultDeviceSdkName.equals(deviceSdkName);
    }

    private IActionDelegate findActionDelegate(IDevice device) {
        IActionDelegate delegate = null;
        DeviceEditorConfigElement element = DeviceEditorRegistry.findEditorElement(device);
        if (element != null) {
            try {
                delegate = element.getActionDelegate();
            }
            catch (CoreException e) {
                MTJLogger.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_findActionDelegate, (Throwable)e);
            }
        }
        return delegate;
    }

    private void handleException(String message, Throwable throwable) {
        MTJLogger.log((int)2, (String)MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_exception, (Throwable)throwable);
        MTJUIPlugin.displayError(this.getShell(), 2, -999, MTJUIMessages.DeviceManagementPreferencePage_error_device_registry_error, message, throwable);
    }

    private String findUniqueName(IDevice device) {
        Pattern UNIQUE_NAME_PATTERN = Pattern.compile("^.+\\((\\d+)\\)$");
        String uniqueName = null;
        String groupName = device.getSDKName();
        String baseName = device.getName();
        int i = 1;
        while (i <= 100) {
            StringBuffer deviceNameBuffer = new StringBuffer(baseName);
            Matcher matcher = UNIQUE_NAME_PATTERN.matcher(deviceNameBuffer);
            if (matcher.find()) {
                int matchStart = matcher.start(1);
                int matchEnd = matcher.end(1);
                deviceNameBuffer.replace(matchStart, matchEnd, Integer.toString(i));
            } else {
                deviceNameBuffer.append(" (").append(i).append(")");
            }
            uniqueName = deviceNameBuffer.toString();
            try {
                IMIDPDevice foundDevice = (IMIDPDevice)DeviceRegistry.getInstance().getDevice(groupName, uniqueName);
                if (foundDevice == null) {
                    break;
                }
            }
            catch (PersistenceException e) {
                MTJLogger.log((int)4, (String)MTJUIMessages.DeviceManagementPreferencePage_error_find_device, (Throwable)e);
            }
            ++i;
        }
        return uniqueName;
    }

    private static class MTJObject {
        private Object payload;
        boolean isDevice;
        boolean isSdk;
        boolean isSdkProvider;
        boolean canEdit;
        boolean canDuplicate;
        boolean canSetDefault;
        boolean canExpand;
        boolean canDelete;

        MTJObject(Object payload) {
            this.payload = payload;
            if (payload instanceof IDevice) {
                this.isDevice = true;
                this.canEdit = true;
                this.canDuplicate = true;
                this.canDelete = payload instanceof IManagedDevice ? ((IManagedDevice)payload).isDuplicate() : true;
                this.canSetDefault = true;
            } else if (payload instanceof ISDK) {
                this.isSdk = true;
                this.canExpand = true;
                this.canDelete = !(payload instanceof ManagedSDK);
            } else if (payload instanceof ISDKProvider) {
                this.isSdkProvider = true;
                this.canExpand = true;
                this.canDelete = payload instanceof ImportedSDKProvider;
            } else {
                throw new IllegalArgumentException();
            }
        }

        IDevice getDevice() {
            return this.isDevice ? (IDevice)this.payload : null;
        }

        ISDK getSdk() {
            return this.isSdk ? (ISDK)this.payload : null;
        }

        ISDKProvider getSdkProvider() {
            return this.isSdkProvider ? (ISDKProvider)this.payload : null;
        }
    }
}

