/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class J2MEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.J2MEPreferencePage";
    private IntegerFieldEditor dbgServPoll;
    private IntegerFieldEditor dbgTimeOut;
    private StringFieldEditor deploymentDirectory;

    public J2MEPreferencePage() {
        super(1);
        this.setPreferenceStore(MTJUIPlugin.getDefault().getCorePreferenceStore());
        this.setDescription(MTJUIMessages.J2MEPreferencePage_description);
    }

    public void createFieldEditors() {
        int columnSpan = 3;
        Composite parent = this.getFieldEditorParent();
        this.deploymentDirectory = new StringFieldEditor("deployment_dir", MTJUIMessages.J2MEPreferencePage_deployment_directory, parent);
        this.deploymentDirectory.setErrorMessage(String.valueOf(this.deploymentDirectory.getLabelText()) + " " + this.deploymentDirectory.getErrorMessage());
        this.addField((FieldEditor)this.deploymentDirectory);
        this.addSpacer(parent, columnSpan);
        Group antennaGroup = new Group(parent, 0);
        antennaGroup.setText(MTJUIMessages.J2MEPreferencePage_antenna_settings);
        antennaGroup.setLayout((Layout)new GridLayout(1, true));
        GridData antennaGD = this.getColumnSpanGridData(columnSpan);
        antennaGD.minimumWidth = 500;
        antennaGroup.setLayoutData((Object)antennaGD);
        Composite antennaComposite = new Composite((Composite)antennaGroup, 0);
        antennaComposite.setLayout((Layout)new GridLayout(3, true));
        antennaComposite.setLayoutData((Object)new GridData(1808));
        FileFieldEditor antennaJarEditor = new FileFieldEditor("antenna_jar", MTJUIMessages.J2MEPreferencePage_antenna_JAR, true, antennaComposite);
        antennaJarEditor.setFileExtensions(new String[]{"*.jar"});
        this.addField((FieldEditor)antennaJarEditor);
        DirectoryFieldEditor wtkRootEditor = new DirectoryFieldEditor("wtk_root", MTJUIMessages.J2MEPreferencePage_WTK_root, antennaComposite);
        this.addField((FieldEditor)wtkRootEditor);
        this.addSpacer(parent, columnSpan);
        Group proguardGroup = new Group(parent, 0);
        proguardGroup.setText(MTJUIMessages.J2MEPreferencePage_proguard_settings);
        proguardGroup.setLayout((Layout)new GridLayout(1, true));
        GridData proguardGD = this.getColumnSpanGridData(columnSpan);
        proguardGD.minimumWidth = 500;
        proguardGroup.setLayoutData((Object)proguardGD);
        Composite proguardComposite = new Composite((Composite)proguardGroup, 0);
        proguardComposite.setLayout((Layout)new GridLayout(3, true));
        proguardComposite.setLayoutData((Object)new GridData(1808));
        this.addField((FieldEditor)new ProguardDirectoryFieldEditor("proguard_dir", MTJUIMessages.ObfuscationPreferencePage_proguard_root_directory, proguardComposite));
        this.addSpacer(parent, columnSpan);
        this.dbgTimeOut = new IntegerFieldEditor("rmt_debug_delay", MTJUIMessages.J2MEPreferencePage_debug_server_time_out, parent);
        this.dbgTimeOut.setErrorMessage(String.valueOf(this.dbgTimeOut.getLabelText()) + MTJUIMessages.J2MEPreferencePage_0 + this.dbgTimeOut.getErrorMessage());
        this.addField((FieldEditor)this.dbgTimeOut);
        this.dbgServPoll = new IntegerFieldEditor("rmt_debug_poll_interval", MTJUIMessages.J2MEPreferencePage_debug_server_poll_interval, parent);
        this.dbgServPoll.setErrorMessage(String.valueOf(this.dbgServPoll.getLabelText()) + " " + this.dbgServPoll.getErrorMessage());
        this.addField((FieldEditor)this.dbgServPoll);
        Label l = new Label(parent, 0);
        l.setText(MTJUIMessages.J2MEPreferencePage_maximum_duration_launch);
        l.setLayoutData((Object)this.getColumnSpanGridData(columnSpan));
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        boolean dbgServPollValid = this.dbgServPoll.isValid();
        boolean dbgTimeOutValid = this.dbgTimeOut.isValid();
        boolean deploymentDirectoryIsValid = Utils.isValidFolderName((String)this.deploymentDirectory.getStringValue());
        if (!(deploymentDirectoryIsValid && dbgServPollValid && dbgTimeOutValid)) {
            if (!deploymentDirectoryIsValid) {
                this.setErrorMessage(this.deploymentDirectory.getErrorMessage());
                this.setValid(Utils.isValidFolderName((String)this.deploymentDirectory.getStringValue()));
            }
            if (!dbgServPollValid) {
                this.setErrorMessage(this.dbgServPoll.getErrorMessage());
            } else if (!dbgTimeOutValid) {
                this.setErrorMessage(this.dbgTimeOut.getErrorMessage());
            }
        } else {
            this.setValid(true);
        }
    }

    private void addSpacer(Composite parent, int columnSpan) {
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)this.getColumnSpanGridData(columnSpan));
    }

    private GridData getColumnSpanGridData(int columnSpan) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = columnSpan;
        return gd;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mtj.ui.help_J2MEPreferencePage");
        return super.createContents(parent);
    }

    private class ProguardDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public ProguardDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        private boolean isProguardFolder(File folder) {
            String jarPath = NLS.bind((String)"lib{0}proguard.jar", (Object)File.separator);
            File jarFile = new File(folder, jarPath);
            return jarFile.exists();
        }

        protected boolean doCheckState() {
            boolean result = false;
            File folder = null;
            String path = null;
            path = this.getStringValue();
            if (path != null && path.trim().length() > 0) {
                folder = new File(path);
                if (folder.isDirectory()) {
                    if (this.isProguardFolder(folder)) {
                        result = true;
                    } else {
                        this.setErrorMessage(NLS.bind((String)MTJUIMessages.ObfuscationPreferencePage_couldNotFindProguardJAr, (Object)folder.getAbsolutePath()));
                    }
                } else {
                    this.setErrorMessage(MTJUIMessages.ObfuscationPreferencePage_NotAFolder);
                }
            } else {
                result = true;
            }
            return result;
        }
    }
}

