/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MultiValuedTableFieldEditor
extends FieldEditor {
    private static final String[] COLUMNS = new String[]{"Value"};
    private static final String[] COLUMN_PROPS = new String[]{"propNames"};
    private Group group;
    private TableViewer tableViewer;
    private StringHolder[] holders;

    public MultiValuedTableFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public int getNumberOfControls() {
        return 1;
    }

    private void addNewPropertyName() {
        StringHolder[] newExpressionArray = new StringHolder[this.holders.length + 1];
        System.arraycopy(this.holders, 0, newExpressionArray, 0, this.holders.length);
        newExpressionArray[this.holders.length] = new StringHolder("New Value");
        this.setExcludedNames(newExpressionArray);
    }

    private String getMultiValuedString(StringHolder[] holders) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < holders.length) {
            StringHolder holder = holders[i];
            if (i != 0) {
                sb.append("|");
            }
            sb.append(holder.value);
            ++i;
        }
        return sb.toString();
    }

    private StringHolder[] getParsedValues(String multiValueString) {
        StringTokenizer st = new StringTokenizer(multiValueString, "|");
        int count = st.countTokens();
        StringHolder[] holders = new StringHolder[count];
        int i = 0;
        while (i < count) {
            holders[i] = new StringHolder(st.nextToken());
            ++i;
        }
        return holders;
    }

    private void removeSelectedNames() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        ArrayList<StringHolder> temp = new ArrayList<StringHolder>(Arrays.asList(this.holders));
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            temp.remove(index);
            --i;
        }
        this.setExcludedNames(temp.toArray(new StringHolder[temp.size()]));
    }

    private void setExcludedNames(StringHolder[] newPropertyNames) {
        this.holders = newPropertyNames;
        this.tableViewer.setInput((Object)this.holders);
        this.tableViewer.refresh();
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.group.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = numColumns;
        this.group = new Group(parent, 0);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)gridData);
        this.group.setText(this.getLabelText());
        this.tableViewer = new TableViewer((Composite)this.group, 68356);
        this.tableViewer.setColumnProperties(COLUMN_PROPS);
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        final Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        Composite buttonHolder = new Composite((Composite)this.group, 0);
        buttonHolder.setLayout((Layout)new GridLayout(1, true));
        Button addButton = new Button(buttonHolder, 8);
        addButton.setText("Add");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValuedTableFieldEditor.this.addNewPropertyName();
            }
        });
        new Label(buttonHolder, 0);
        final Button removeButton = new Button(buttonHolder, 8);
        removeButton.setText("Remove");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiValuedTableFieldEditor.this.removeSelectedNames();
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        this.tableViewer.setCellEditors(cellEditorArray);
        final TableColumn[] columns = new TableColumn[COLUMNS.length];
        int i = 0;
        while (i < COLUMNS.length) {
            columns[i] = new TableColumn(table, 0);
            columns[i].setText(COLUMNS[i]);
            ++i;
        }
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                columns[0].setWidth(table.getSize().x);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    protected void doLoad() {
        if (this.group != null) {
            String propNames = this.getPreferenceStore().getString(this.getPreferenceName());
            this.setExcludedNames(this.getParsedValues(propNames));
        }
    }

    protected void doLoadDefault() {
        if (this.group != null) {
            String propNames = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.setExcludedNames(this.getParsedValues(propNames));
        }
    }

    protected void doStore() {
        String prefValue = this.getMultiValuedString(this.holders);
        this.getPreferenceStore().setValue(this.getPreferenceName(), prefValue);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property != null && property.equals(COLUMN_PROPS[0]);
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (this.canModify(element, property)) {
                value = element.toString();
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof StringHolder) {
                    ((StringHolder)data).value = newValue;
                    MultiValuedTableFieldEditor.this.tableViewer.update(data, new String[]{property});
                }
            }
        }
    }

    private static class StringHolder {
        public String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return MultiValuedTableFieldEditor.this.holders;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? element.toString() : "";
        }
    }
}

