/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.preferences.MultiValuedTableFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ObfuscationPreferencePage
extends FieldEditorPreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mtj.ui.preferences.ObfuscationPreferencePage";
    private boolean embeddedInProperties;
    private Button specifiedArgumentsButton;
    private Text specifiedArgumentsText;

    public ObfuscationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public ObfuscationPreferencePage(boolean embeddedInProperties, IPreferenceStore preferenceStore) {
        super(1);
        this.embeddedInProperties = embeddedInProperties;
        this.setPreferenceStore(preferenceStore);
        if (!embeddedInProperties) {
            this.setDescription(MTJUIMessages.ObfuscationPreferencePage_description);
        }
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Font font = parent.getFont();
        this.specifiedArgumentsButton = new Button(parent, 32);
        this.specifiedArgumentsButton.setText(MTJUIMessages.ObfuscationPreferencePage_specified_arguments);
        this.specifiedArgumentsButton.setFont(font);
        this.specifiedArgumentsText = new Text(parent, 2052);
        this.specifiedArgumentsText.setFont(font);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.specifiedArgumentsText.setLayoutData((Object)gd);
        this.specifiedArgumentsText.setEnabled(false);
        this.specifiedArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObfuscationPreferencePage.this.specifiedArgumentsText.setEnabled(ObfuscationPreferencePage.this.specifiedArgumentsButton.getSelection());
            }
        });
        this.addField(new MultiValuedTableFieldEditor("proguard_keep", MTJUIMessages.ObfuscationPreferencePage_proguard_keep_expressions, parent));
        this.addProguardNotes(parent, font);
    }

    public void init(IWorkbench workbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        super.performDefaults();
        this.setState(false, "-dontusemixedcaseclassnames -dontnote -defaultpackage ''");
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean useSpecified = this.specifiedArgumentsButton.getSelection();
        store.setValue("proguard_use_specified", useSpecified);
        store.setValue("proguard_options", this.specifiedArgumentsText.getText());
        return super.performOk();
    }

    private void addProguardNotes(Composite parent, Font font) {
        Label notes = new Label(parent, 0);
        notes.setFont(font);
        notes.setText(MTJUIMessages.ObfuscationPreferencePage_proguard_note);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        notes.setLayoutData((Object)gd);
    }

    private void setState(boolean useSpecified, String specified) {
        this.specifiedArgumentsButton.setSelection(useSpecified);
        this.specifiedArgumentsText.setText(specified);
        this.specifiedArgumentsText.setEnabled(useSpecified);
    }

    protected Control createContents(Composite parent) {
        if (this.embeddedInProperties) {
            this.noDefaultAndApplyButton();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mtj.ui.help_ObfuscationPreferencePage");
        return super.createContents(parent);
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore store = this.getPreferenceStore();
        this.setState(store.getBoolean("proguard_use_specified"), store.getString("proguard_options"));
    }
}

