/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessorHelper;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class PreprocessPreferencePage
extends PreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String DEBUGLEVEL_NONE = "none";
    private Combo debugLevelCombo;
    private Label debugLevelLabel;
    private boolean embeddedInProperties;

    public PreprocessPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public PreprocessPreferencePage(boolean embeddedInProperties, IPreferenceStore preferenceStore) {
        this.embeddedInProperties = embeddedInProperties;
        this.setPreferenceStore(preferenceStore);
    }

    public void init(IWorkbench workbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        this.setControlsFromDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        this.setPreferencesFromControls();
        return super.performOk();
    }

    private void addDebugLevelControls(Composite composite) {
        Group debugLevelSettingGroup = new Group(composite, 0);
        debugLevelSettingGroup.setText(MTJUIMessages.PreprocessPreferencePage_debugLevelSettingGroup_label_text);
        debugLevelSettingGroup.setLayout((Layout)new GridLayout(2, false));
        debugLevelSettingGroup.setLayoutData((Object)new GridData(768));
        this.debugLevelLabel = new Label((Composite)debugLevelSettingGroup, 0);
        this.debugLevelLabel.setFont(composite.getFont());
        this.debugLevelLabel.setText(MTJUIMessages.PreprocessPreferencePage_debugLevel_label_text);
        this.debugLevelCombo = new Combo((Composite)debugLevelSettingGroup, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        this.debugLevelCombo.setLayoutData((Object)gridData);
        String[] supportDebugLevels = PreprocessorHelper.getSupportDebugLevels();
        String[] items = new String[supportDebugLevels.length + 1];
        items[0] = DEBUGLEVEL_NONE;
        System.arraycopy(supportDebugLevels, 0, items, 1, supportDebugLevels.length);
        this.debugLevelCombo.setItems(items);
    }

    private void selectDebuglevel(String debuglevel) {
        int debuglevelIdx = 0;
        String[] stringArray = this.debugLevelCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String level = stringArray[n2];
            if (level.equalsIgnoreCase(debuglevel)) break;
            ++debuglevelIdx;
            ++n2;
        }
        if (debuglevelIdx < this.debugLevelCombo.getItems().length) {
            this.debugLevelCombo.select(debuglevelIdx);
        }
    }

    private void setControlsFromDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        String debuglevel = store.getDefaultString("preprocess_debuglevel");
        this.selectDebuglevel(debuglevel);
    }

    private void setControlsFromPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        String debuglevel = store.getString("preprocess_debuglevel");
        this.selectDebuglevel(debuglevel);
    }

    private void setPreferencesFromControls() {
        IPreferenceStore store = this.getPreferenceStore();
        int index = this.debugLevelCombo.getSelectionIndex();
        store.setValue("preprocess_debuglevel", this.debugLevelCombo.getItem(index));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.addDebugLevelControls(composite);
        if (this.embeddedInProperties) {
            this.noDefaultAndApplyButton();
        }
        this.setControlsFromPreferences();
        return composite;
    }
}

